/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.slots;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.messages.StopCluster;
import org.apache.flink.runtime.concurrent.impl.FlinkFuture;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.messages.StackTrace;
import org.apache.flink.runtime.messages.StackTraceSampleMessages;
import org.apache.flink.runtime.messages.StackTraceSampleResponse;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.messages.TaskManagerMessages$SendStackTrace$;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.messages.checkpoint.NotifyCheckpointComplete;
import org.apache.flink.runtime.messages.checkpoint.TriggerCheckpoint;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;

public class ActorTaskManagerGateway
implements TaskManagerGateway {
    private final ActorGateway actorGateway;

    public ActorTaskManagerGateway(ActorGateway actorGateway) {
        this.actorGateway = (ActorGateway)Preconditions.checkNotNull((Object)actorGateway);
    }

    public ActorGateway getActorGateway() {
        return this.actorGateway;
    }

    @Override
    public String getAddress() {
        return this.actorGateway.path();
    }

    @Override
    public void disconnectFromJobManager(InstanceID instanceId, Exception cause) {
        this.actorGateway.tell(new Messages.Disconnect(instanceId, cause));
    }

    @Override
    public void stopCluster(ApplicationStatus applicationStatus, String message) {
        this.actorGateway.tell(new StopCluster(applicationStatus, message));
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<StackTrace> requestStackTrace(Time timeout) {
        Preconditions.checkNotNull((Object)timeout);
        Future stackTraceFuture = this.actorGateway.ask(TaskManagerMessages$SendStackTrace$.MODULE$.get(), new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(StackTrace.class));
        return new FlinkFuture<StackTrace>(stackTraceFuture);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<StackTraceSampleResponse> requestStackTraceSample(ExecutionAttemptID executionAttemptID, int sampleId, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, Time timeout) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkArgument((numSamples > 0 ? 1 : 0) != 0, (Object)"The number of samples must be greater than 0.");
        Preconditions.checkNotNull((Object)delayBetweenSamples);
        Preconditions.checkArgument((maxStackTraceDepth >= 0 ? 1 : 0) != 0, (Object)"The max stack trace depth must be greater or equal than 0.");
        Preconditions.checkNotNull((Object)timeout);
        Future stackTraceSampleResponseFuture = this.actorGateway.ask(new StackTraceSampleMessages.TriggerStackTraceSample(sampleId, executionAttemptID, numSamples, delayBetweenSamples, maxStackTraceDepth), new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(StackTraceSampleResponse.class));
        return new FlinkFuture<StackTraceSampleResponse>(stackTraceSampleResponseFuture);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
        Preconditions.checkNotNull((Object)tdd);
        Preconditions.checkNotNull((Object)timeout);
        Future submitResult = this.actorGateway.ask(new TaskMessages.SubmitTask(tdd), new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(Acknowledge.class));
        return new FlinkFuture<Acknowledge>(submitResult);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<Acknowledge> stopTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkNotNull((Object)timeout);
        Future stopResult = this.actorGateway.ask(new TaskMessages.StopTask(executionAttemptID), new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(Acknowledge.class));
        return new FlinkFuture<Acknowledge>(stopResult);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkNotNull((Object)timeout);
        Future cancelResult = this.actorGateway.ask(new TaskMessages.CancelTask(executionAttemptID), new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(Acknowledge.class));
        return new FlinkFuture<Acknowledge>(cancelResult);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkNotNull(partitionInfos);
        TaskMessages.UpdateTaskMultiplePartitionInfos updatePartitionInfoMessage = new TaskMessages.UpdateTaskMultiplePartitionInfos(executionAttemptID, partitionInfos);
        Future updatePartitionsResult = this.actorGateway.ask(updatePartitionInfoMessage, new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(Acknowledge.class));
        return new FlinkFuture<Acknowledge>(updatePartitionsResult);
    }

    @Override
    public void failPartition(ExecutionAttemptID executionAttemptID) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        this.actorGateway.tell(new TaskMessages.FailIntermediateResultPartitions(executionAttemptID));
    }

    @Override
    public void notifyCheckpointComplete(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkNotNull((Object)jobId);
        this.actorGateway.tell(new NotifyCheckpointComplete(jobId, executionAttemptID, checkpointId, timestamp));
    }

    @Override
    public void triggerCheckpoint(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
        Preconditions.checkNotNull((Object)((Object)executionAttemptID));
        Preconditions.checkNotNull((Object)jobId);
        this.actorGateway.tell(new TriggerCheckpoint(jobId, executionAttemptID, checkpointId, timestamp));
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<BlobKey> requestTaskManagerLog(Time timeout) {
        return this.requestTaskManagerLog((TaskManagerMessages.RequestTaskManagerLog)TaskManagerMessages.getRequestTaskManagerLog(), timeout);
    }

    @Override
    public org.apache.flink.runtime.concurrent.Future<BlobKey> requestTaskManagerStdout(Time timeout) {
        return this.requestTaskManagerLog((TaskManagerMessages.RequestTaskManagerLog)TaskManagerMessages.getRequestTaskManagerStdout(), timeout);
    }

    private org.apache.flink.runtime.concurrent.Future<BlobKey> requestTaskManagerLog(TaskManagerMessages.RequestTaskManagerLog request, Time timeout) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)timeout);
        Future blobKeyFuture = this.actorGateway.ask(request, new FiniteDuration(timeout.getSize(), timeout.getUnit())).mapTo(ClassTag$.MODULE$.apply(BlobKey.class));
        return new FlinkFuture<BlobKey>(blobKeyFuture);
    }
}

