/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.Preconditions;

public class JobDetails
implements Serializable {
    private static final long serialVersionUID = -3391462110304948766L;
    private final JobID jobId;
    private final String jobName;
    private final long startTime;
    private final long endTime;
    private final JobStatus status;
    private final long lastUpdateTime;
    private final int[] numVerticesPerExecutionState;
    private final int numTasks;

    public JobDetails(JobID jobId, String jobName, long startTime, long endTime, JobStatus status, long lastUpdateTime, int[] numVerticesPerExecutionState, int numTasks) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = (JobStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.lastUpdateTime = lastUpdateTime;
        this.numVerticesPerExecutionState = (int[])Preconditions.checkNotNull((Object)numVerticesPerExecutionState);
        this.numTasks = numTasks;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public int[] getNumVerticesPerExecutionState() {
        return this.numVerticesPerExecutionState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == JobDetails.class) {
            JobDetails that = (JobDetails)o;
            return this.endTime == that.endTime && this.lastUpdateTime == that.lastUpdateTime && this.numTasks == that.numTasks && this.startTime == that.startTime && this.status == that.status && this.jobId.equals((Object)that.jobId) && this.jobName.equals(that.jobName) && Arrays.equals(this.numVerticesPerExecutionState, that.numVerticesPerExecutionState);
        }
        return false;
    }

    public int hashCode() {
        int result = this.jobId.hashCode();
        result = 31 * result + this.jobName.hashCode();
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.lastUpdateTime ^ this.lastUpdateTime >>> 32);
        result = 31 * result + Arrays.hashCode(this.numVerticesPerExecutionState);
        result = 31 * result + this.numTasks;
        return result;
    }

    public String toString() {
        return "JobDetails {jobId=" + this.jobId + ", jobName='" + this.jobName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", status=" + (Object)((Object)this.status) + ", lastUpdateTime=" + this.lastUpdateTime + ", numVerticesPerExecutionState=" + Arrays.toString(this.numVerticesPerExecutionState) + ", numTasks=" + this.numTasks + '}';
    }
}

