/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.flink.util.Preconditions;

public class KvStateServerAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InetAddress hostAddress;
    private final int port;

    public KvStateServerAddress(InetAddress hostAddress, int port) {
        this.hostAddress = (InetAddress)Preconditions.checkNotNull((Object)hostAddress, (String)"Host address");
        Preconditions.checkArgument((port > 0 && port <= 65535 ? 1 : 0) != 0, (Object)("Port " + port + " is out of range 1-65535"));
        this.port = port;
    }

    public InetAddress getHost() {
        return this.hostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvStateServerAddress that = (KvStateServerAddress)o;
        return this.port == that.port && this.hostAddress.equals(that.hostAddress);
    }

    public int hashCode() {
        int result = this.hostAddress.hashCode();
        result = 31 * result + this.port;
        return result;
    }
}

