/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class OperatorBackendSerializationProxy
extends VersionedIOReadableWritable {
    private static final int VERSION = 1;
    private List<StateMetaInfo<?>> namedStateSerializationProxies;
    private ClassLoader userCodeClassLoader;

    public OperatorBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public OperatorBackendSerializationProxy(List<StateMetaInfo<?>> namedStateSerializationProxies) {
        this.namedStateSerializationProxies = (List)Preconditions.checkNotNull(namedStateSerializationProxies);
        Preconditions.checkArgument((namedStateSerializationProxies.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public int getVersion() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeShort(this.namedStateSerializationProxies.size());
        for (StateMetaInfo<?> kvState : this.namedStateSerializationProxies) {
            kvState.write(out);
        }
    }

    public void read(DataInputView out) throws IOException {
        super.read(out);
        int numKvStates = out.readShort();
        this.namedStateSerializationProxies = new ArrayList(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            StateMetaInfo stateSerializationProxy = new StateMetaInfo(this.userCodeClassLoader);
            stateSerializationProxy.read(out);
            this.namedStateSerializationProxies.add(stateSerializationProxy);
        }
    }

    public List<StateMetaInfo<?>> getNamedStateSerializationProxies() {
        return this.namedStateSerializationProxies;
    }

    public static class StateMetaInfo<S>
    implements IOReadableWritable {
        private String name;
        private TypeSerializer<S> stateSerializer;
        private OperatorStateHandle.Mode mode;
        private ClassLoader userClassLoader;

        @VisibleForTesting
        public StateMetaInfo(ClassLoader userClassLoader) {
            this.userClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userClassLoader);
        }

        public StateMetaInfo(String name, TypeSerializer<S> stateSerializer, OperatorStateHandle.Mode mode) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.stateSerializer = (TypeSerializer)Preconditions.checkNotNull(stateSerializer);
            this.mode = (OperatorStateHandle.Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TypeSerializer<S> getStateSerializer() {
            return this.stateSerializer;
        }

        public void setStateSerializer(TypeSerializer<S> stateSerializer) {
            this.stateSerializer = stateSerializer;
        }

        public OperatorStateHandle.Mode getMode() {
            return this.mode;
        }

        public void setMode(OperatorStateHandle.Mode mode) {
            this.mode = mode;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeUTF(this.getName());
            out.writeByte(this.getMode().ordinal());
            DataOutputViewStream dos = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)dos, this.getStateSerializer());
        }

        public void read(DataInputView in) throws IOException {
            this.setName(in.readUTF());
            this.setMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            DataInputViewStream dis = new DataInputViewStream(in);
            try {
                TypeSerializer stateSerializer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)dis, (ClassLoader)this.userClassLoader);
                this.setStateSerializer(stateSerializer);
            }
            catch (ClassNotFoundException exception) {
                throw new IOException(exception);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateMetaInfo metaInfo = (StateMetaInfo)o;
            if (!this.getName().equals(metaInfo.getName())) {
                return false;
            }
            if (!this.getStateSerializer().equals(metaInfo.getStateSerializer())) {
                return false;
            }
            return this.getMode() == metaInfo.getMode();
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + this.getStateSerializer().hashCode();
            result = 31 * result + this.getMode().hashCode();
            return result;
        }
    }
}

