/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class OperatorStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 35876522969227335L;
    private final Map<String, StateMetaInfo> stateNameToPartitionOffsets;
    private final StreamStateHandle delegateStateHandle;

    public OperatorStateHandle(Map<String, StateMetaInfo> stateNameToPartitionOffsets, StreamStateHandle delegateStateHandle) {
        this.delegateStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)delegateStateHandle);
        this.stateNameToPartitionOffsets = (Map)Preconditions.checkNotNull(stateNameToPartitionOffsets);
    }

    public Map<String, StateMetaInfo> getStateNameToPartitionOffsets() {
        return this.stateNameToPartitionOffsets;
    }

    @Override
    public void discardState() throws Exception {
        this.delegateStateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.delegateStateHandle.getStateSize();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.delegateStateHandle.openInputStream();
    }

    public StreamStateHandle getDelegateStateHandle() {
        return this.delegateStateHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorStateHandle)) {
            return false;
        }
        OperatorStateHandle that = (OperatorStateHandle)o;
        if (this.stateNameToPartitionOffsets.size() != that.stateNameToPartitionOffsets.size()) {
            return false;
        }
        for (Map.Entry<String, StateMetaInfo> entry : this.stateNameToPartitionOffsets.entrySet()) {
            if (entry.getValue().equals(that.stateNameToPartitionOffsets.get(entry.getKey()))) continue;
            return false;
        }
        return this.delegateStateHandle.equals(that.delegateStateHandle);
    }

    public int hashCode() {
        int result = this.delegateStateHandle.hashCode();
        for (Map.Entry<String, StateMetaInfo> entry : this.stateNameToPartitionOffsets.entrySet()) {
            int entryHash = entry.getKey().hashCode();
            if (entry.getValue() != null) {
                entryHash += entry.getValue().hashCode();
            }
            result = 31 * result + entryHash;
        }
        return result;
    }

    public String toString() {
        return "OperatorStateHandle{stateNameToPartitionOffsets=" + this.stateNameToPartitionOffsets + ", delegateStateHandle=" + this.delegateStateHandle + '}';
    }

    public static class StateMetaInfo
    implements Serializable {
        private static final long serialVersionUID = 3593817615858941166L;
        private final long[] offsets;
        private final Mode distributionMode;

        public StateMetaInfo(long[] offsets, Mode distributionMode) {
            this.offsets = (long[])Preconditions.checkNotNull((Object)offsets);
            this.distributionMode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)distributionMode)));
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public Mode getDistributionMode() {
            return this.distributionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateMetaInfo that = (StateMetaInfo)o;
            if (!Arrays.equals(this.getOffsets(), that.getOffsets())) {
                return false;
            }
            return this.getDistributionMode() == that.getDistributionMode();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.getOffsets());
            result = 31 * result + this.getDistributionMode().hashCode();
            return result;
        }

        public String toString() {
            return "StateMetaInfo{offsets=" + Arrays.toString(this.offsets) + ", distributionMode=" + (Object)((Object)this.distributionMode) + '}';
        }
    }

    public static enum Mode {
        SPLIT_DISTRIBUTE,
        BROADCAST;

    }
}

