/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.runtime.util.NonClosingStreamDecorator;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StatePartitionStreamProvider {
    private final InputStream stream;
    private final IOException creationException;

    public StatePartitionStreamProvider(IOException creationException) {
        this.creationException = (IOException)Preconditions.checkNotNull((Object)creationException);
        this.stream = null;
    }

    public StatePartitionStreamProvider(InputStream stream) {
        this.stream = new NonClosingStreamDecorator((InputStream)Preconditions.checkNotNull((Object)stream));
        this.creationException = null;
    }

    public InputStream getStream() throws IOException {
        if (this.creationException != null) {
            throw new IOException(this.creationException);
        }
        return this.stream;
    }
}

