/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.util.Preconditions;

public class HeapFoldingState<K, N, T, ACC>
extends AbstractHeapState<K, N, ACC, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>>
implements FoldingState<T, ACC> {
    private final FoldFunction<T, ACC> foldFunction;

    public HeapFoldingState(KeyedStateBackend<K> backend, FoldingStateDescriptor<T, ACC> stateDesc, StateTable<K, N, ACC> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(backend, stateDesc, stateTable, keySerializer, namespaceSerializer);
        this.foldFunction = stateDesc.getFoldFunction();
    }

    public ACC get() {
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            return null;
        }
        Map keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return null;
        }
        return (ACC)keyedMap.get(this.backend.getCurrentKey());
    }

    public void add(T value) throws IOException {
        Map<Object, Object> keyedMap;
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        if (value == null) {
            this.clear();
            return;
        }
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            namespaceMap = this.createNewMap();
            this.stateTable.set(this.backend.getCurrentKeyGroupIndex(), namespaceMap);
        }
        if ((keyedMap = namespaceMap.get(this.currentNamespace)) == null) {
            keyedMap = this.createNewMap();
            namespaceMap.put(this.currentNamespace, keyedMap);
        }
        Object currentValue = keyedMap.get(this.backend.getCurrentKey());
        try {
            if (currentValue == null) {
                keyedMap.put(this.backend.getCurrentKey(), this.foldFunction.fold(((FoldingStateDescriptor)this.stateDesc).getDefaultValue(), value));
            } else {
                keyedMap.put(this.backend.getCurrentKey(), this.foldFunction.fold(currentValue, value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add value to folding state.", e);
        }
    }
}

