/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class ByteStreamStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = -5280226231202517594L;
    protected final byte[] data;
    protected final String handleName;

    public ByteStreamStateHandle(String handleName, byte[] data) {
        this.handleName = (String)Preconditions.checkNotNull((Object)handleName);
        this.data = (byte[])Preconditions.checkNotNull((Object)data);
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return new ByteStateHandleInputStream();
    }

    public byte[] getData() {
        return this.data;
    }

    public String getHandleName() {
        return this.handleName;
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteStreamStateHandle)) {
            return false;
        }
        ByteStreamStateHandle that = (ByteStreamStateHandle)o;
        return this.handleName.equals(that.handleName);
    }

    public int hashCode() {
        return 31 * this.handleName.hashCode();
    }

    private final class ByteStateHandleInputStream
    extends FSDataInputStream {
        private int index = 0;

        public void seek(long desired) throws IOException {
            Preconditions.checkArgument((desired >= 0L && desired < Integer.MAX_VALUE ? 1 : 0) != 0);
            this.index = (int)desired;
        }

        public long getPos() throws IOException {
            return this.index;
        }

        public int read() throws IOException {
            return this.index < ByteStreamStateHandle.this.data.length ? ByteStreamStateHandle.this.data[this.index++] & 0xFF : -1;
        }
    }
}

