/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerConnection;
import org.apache.flink.util.Preconditions;

public class ActorGatewayTaskManagerConnection
implements TaskManagerConnection {
    private final ActorGateway actorGateway;

    public ActorGatewayTaskManagerConnection(ActorGateway actorGateway) {
        this.actorGateway = (ActorGateway)Preconditions.checkNotNull((Object)actorGateway);
    }

    @Override
    public void notifyFinalState(ExecutionAttemptID executionAttemptID) {
        this.actorGateway.tell(new TaskMessages.TaskInFinalState(executionAttemptID));
    }

    @Override
    public void notifyFatalError(String message, Throwable cause) {
        this.actorGateway.tell(new TaskManagerMessages.FatalError(message, cause));
    }

    @Override
    public void failTask(ExecutionAttemptID executionAttemptID, Throwable cause) {
        this.actorGateway.tell(new TaskMessages.FailTask(executionAttemptID, cause));
    }

    @Override
    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        TaskMessages.UpdateTaskExecutionState actorMessage = new TaskMessages.UpdateTaskExecutionState(taskExecutionState);
        this.actorGateway.tell(actorMessage);
    }
}

