/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.HybridMemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyConnectionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.netty.DisabledKvStateRequestStats;
import org.apache.flink.runtime.query.netty.KvStateServer;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerCliOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.MathUtils;
import org.jboss.netty.channel.ChannelException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scopt.OptionParser;
import scopt.Read$;

public final class TaskManager$ {
    public static final TaskManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String TASK_MANAGER_NAME;
    private final long MAX_STARTUP_CONNECT_TIME;
    private final long STARTUP_CONNECT_LOG_SUPPRESS;
    private final FiniteDuration HEARTBEAT_INTERVAL;

    static {
        new TaskManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String TASK_MANAGER_NAME() {
        return this.TASK_MANAGER_NAME;
    }

    public long MAX_STARTUP_CONNECT_TIME() {
        return this.MAX_STARTUP_CONNECT_TIME;
    }

    public long STARTUP_CONNECT_LOG_SUPPRESS() {
        return this.STARTUP_CONNECT_LOG_SUPPRESS;
    }

    public FiniteDuration HEARTBEAT_INTERVAL() {
        return this.HEARTBEAT_INTERVAL;
    }

    public void main(String[] args) {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "TaskManager", args);
        SignalHandler.register(this.LOG().logger());
        JvmShutdownSafeguard.installAsShutdownHook(this.LOG().logger());
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            this.LOG().info((Function0)new Serializable(maxOpenFileHandles){
                public static final long serialVersionUID = 0L;
                private final long maxOpenFileHandles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum number of open file descriptors is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxOpenFileHandles$1)}));
                }
                {
                    this.maxOpenFileHandles$1 = maxOpenFileHandles$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot determine the maximum number of open file descriptors";
                }
            });
        }
        try {
            configuration = this.parseArgsAndLoadConfig(args);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final String apply() {
                    return this.t$11.getMessage();
                }
                {
                    this.t$11 = t$11;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            configuration = null;
        }
        Configuration configuration2 = configuration;
        ResourceID resourceId = ResourceID.generate();
        SecurityUtils.install(new SecurityUtils.SecurityConfiguration(configuration2));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<BoxedUnit>(configuration2, resourceId){
                private final Configuration configuration$1;
                private final ResourceID resourceId$1;

                public void call() {
                    TaskManager$.MODULE$.selectNetworkInterfaceAndRunTaskManager(this.configuration$1, this.resourceId$1, TaskManager.class);
                }
                {
                    this.configuration$1 = configuration$1;
                    this.resourceId$1 = resourceId$1;
                }
            });
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run TaskManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$12;

                public final Throwable apply() {
                    return this.t$12;
                }
                {
                    this.t$12 = t$12;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public Configuration parseArgsAndLoadConfig(String[] args) throws Exception {
        Configuration conf;
        OptionParser<TaskManagerCliOptions> parser = new OptionParser<TaskManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink TaskManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setConfigDir(param);
                        return conf;
                    }
                }).text("Specify configuration directory.");
            }
        };
        TaskManagerCliOptions cliConfig = (TaskManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new TaskManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$1).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$1 = args$1;
                this.parser$1 = parser$1;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(cliConfig){
                public static final long serialVersionUID = 0L;
                private final TaskManagerCliOptions cliConfig$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.cliConfig$1.getConfigDir()).toString();
                }
                {
                    this.cliConfig$1 = cliConfig$1;
                }
            });
            conf = GlobalConfiguration.loadConfiguration((String)cliConfig.getConfigDir());
        }
        catch (Exception exception) {
            throw new Exception("Could not load configuration", exception);
        }
        try {
            FileSystem.setDefaultScheme((Configuration)conf);
            return conf;
        }
        catch (IOException iOException) {
            throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
        }
    }

    public void selectNetworkInterfaceAndRunTaskManager(Configuration configuration, ResourceID resourceID, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Tuple2<String, Object> tuple2 = this.selectNetworkInterfaceAndPort(configuration);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String taskManagerHostname = (String)tuple2._1();
            int actorSystemPort = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
            String taskManagerHostname2 = (String)tuple23._1();
            int actorSystemPort2 = tuple23._2$mcI$sp();
            this.runTaskManager(taskManagerHostname2, resourceID, actorSystemPort2, configuration, taskManagerClass);
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, Object> selectNetworkInterfaceAndPort(Configuration configuration) throws IOException, IllegalConfigurationException {
        ObjectRef taskManagerHostname = ObjectRef.create((Object)configuration.getString("taskmanager.hostname", null));
        if ((String)taskManagerHostname.elem == null) {
            LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration);
            FiniteDuration lookupTimeout = AkkaUtils$.MODULE$.getLookupTimeout(configuration);
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(leaderRetrievalService, lookupTimeout);
            taskManagerHostname.elem = taskManagerAddress.getHostName();
            this.LOG().info((Function0)new Serializable(taskManagerHostname, taskManagerAddress){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;
                private final InetAddress taskManagerAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will use hostname/address '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.taskManagerHostname$2.elem}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") for communication."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerAddress$1.getHostAddress()}))).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                    this.taskManagerAddress$1 = taskManagerAddress$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(taskManagerHostname){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using configured hostname/address for TaskManager: ").append((Object)((String)this.taskManagerHostname$2.elem)).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                }
            });
        }
        int actorSystemPort = configuration.getInteger("taskmanager.rpc.port", 0);
        if (actorSystemPort < 0 || actorSystemPort > 65535) {
            throw new IllegalConfigurationException(new StringBuilder().append((Object)"Invalid value for 'taskmanager.rpc.port' (port for the TaskManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - Leave config parameter empty or use 0 to let the system choose a port automatically.").toString());
        }
        return new Tuple2((Object)((String)taskManagerHostname.elem), (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration) throws Exception {
        this.runTaskManager(taskManagerHostname, resourceID, actorSystemPort, configuration, TaskManager.class);
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration, Class<? extends TaskManager> taskManagerClass) throws Exception {
        ActorSystem taskManagerSystem;
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting TaskManager";
            }
        });
        this.LOG().info((Function0)new Serializable(taskManagerHostname, actorSystemPort){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$1;
            private final int actorSystemPort$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager actor system at ", ":", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerHostname$1, BoxesRunTime.boxToInteger((int)this.actorSystemPort$1)}));
            }
            {
                this.taskManagerHostname$1 = taskManagerHostname$1;
                this.actorSystemPort$1 = actorSystemPort$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            taskManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                throw new IOException(new StringBuilder().append((Object)"Unable to bind TaskManager actor system to address ").append((Object)taskManagerHostname).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create TaskManager actor system", throwable);
        }
        try {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager actor";
                }
            });
            ActorRef taskManager = this.startTaskManagerComponentsAndActor(configuration, resourceID, taskManagerSystem, taskManagerHostname, (Option<String>)new Some((Object)this.TASK_MANAGER_NAME()), (Option<LeaderRetrievalService>)None$.MODULE$, false, taskManagerClass);
            this.LOG().debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager process reaper";
                }
            });
            taskManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
            if (this.LOG().isInfoEnabled() && configuration.getBoolean("taskmanager.debug.memory.startLogThread", false)) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting periodic memory usage logger";
                    }
                });
                long interval = configuration.getLong("taskmanager.debug.memory.logIntervalMs", 5000L);
                MemoryLogger logger = new MemoryLogger(this.LOG().logger(), interval, taskManagerSystem);
                logger.start();
            }
            taskManagerSystem.awaitTermination();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up taskManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$13;

                public final Throwable apply() {
                    return this.t$13;
                }
                {
                    this.t$13 = t$13;
                }
            });
            try {
                taskManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$1;

                    public final Throwable apply() {
                        return this.tt$1;
                    }
                    {
                        this.tt$1 = tt$1;
                    }
                });
            }
            throw throwable;
        }
    }

    public ActorRef startTaskManagerComponentsAndActor(Configuration configuration, ResourceID resourceID, ActorSystem actorSystem, String taskManagerHostname, Option<String> taskManagerActorName, Option<LeaderRetrievalService> leaderRetrievalServiceOption, boolean localTaskManagerCommunication, Class<? extends TaskManager> taskManagerClass) throws IllegalConfigurationException, IOException, Exception {
        Tuple7<TaskManagerConfiguration, TaskManagerLocation, MemoryManager, IOManager, NetworkEnvironment, LeaderRetrievalService, MetricRegistry> tuple7;
        block2: {
            Option<String> option;
            block5: {
                ActorRef actorRef;
                block4: {
                    Props tmProps;
                    block3: {
                        Tuple7 tuple72;
                        tuple7 = this.createTaskManagerComponents(configuration, resourceID, taskManagerHostname, localTaskManagerCommunication, leaderRetrievalServiceOption);
                        if (tuple7 == null) break block2;
                        TaskManagerConfiguration taskManagerConfig = (TaskManagerConfiguration)tuple7._1();
                        TaskManagerLocation connectionInfo = (TaskManagerLocation)tuple7._2();
                        MemoryManager memoryManager = (MemoryManager)tuple7._3();
                        IOManager ioManager = (IOManager)tuple7._4();
                        NetworkEnvironment network = (NetworkEnvironment)tuple7._5();
                        LeaderRetrievalService leaderRetrievalService = (LeaderRetrievalService)tuple7._6();
                        MetricRegistry metricsRegistry = (MetricRegistry)tuple7._7();
                        Tuple7 tuple73 = tuple72 = new Tuple7((Object)taskManagerConfig, (Object)connectionInfo, (Object)memoryManager, (Object)ioManager, (Object)network, (Object)leaderRetrievalService, (Object)metricsRegistry);
                        TaskManagerConfiguration taskManagerConfig2 = (TaskManagerConfiguration)tuple73._1();
                        TaskManagerLocation connectionInfo2 = (TaskManagerLocation)tuple73._2();
                        MemoryManager memoryManager2 = (MemoryManager)tuple73._3();
                        IOManager ioManager2 = (IOManager)tuple73._4();
                        NetworkEnvironment network2 = (NetworkEnvironment)tuple73._5();
                        LeaderRetrievalService leaderRetrievalService2 = (LeaderRetrievalService)tuple73._6();
                        MetricRegistry metricsRegistry2 = (MetricRegistry)tuple73._7();
                        tmProps = this.getTaskManagerProps(taskManagerClass, taskManagerConfig2, resourceID, connectionInfo2, memoryManager2, ioManager2, network2, leaderRetrievalService2, metricsRegistry2);
                        metricsRegistry2.startQueryService(actorSystem, resourceID);
                        option = taskManagerActorName;
                        if (!(option instanceof Some)) break block3;
                        Some some = (Some)option;
                        String actorName = (String)some.x();
                        actorRef = actorSystem.actorOf(tmProps, actorName);
                        break block4;
                    }
                    if (!None$.MODULE$.equals(option)) break block5;
                    actorRef = actorSystem.actorOf(tmProps);
                }
                return actorRef;
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple7);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, LeaderRetrievalService leaderRetrievalService, MetricRegistry metricsRegistry) {
        return Props$.MODULE$.apply(taskManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, BoxesRunTime.boxToInteger((int)taskManagerConfig.numberOfSlots()), leaderRetrievalService, metricsRegistry}));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple7<TaskManagerConfiguration, TaskManagerLocation, MemoryManager, IOManager, NetworkEnvironment, LeaderRetrievalService, MetricRegistry> createTaskManagerComponents(Configuration configuration, ResourceID resourceID, String taskManagerHostname, boolean localTaskManagerCommunication, Option<LeaderRetrievalService> leaderRetrievalServiceOption) {
        Tuple4<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InetSocketAddress, MemoryType> tuple4;
        block15: {
            Option<NettyConfig> option;
            block18: {
                boolean bl;
                block21: {
                    block25: {
                        Option<LeaderRetrievalService> option2;
                        block28: {
                            LeaderRetrievalService leaderRetrievalService;
                            IOManagerAsync ioManager;
                            MemoryManager memoryManager;
                            TaskManagerLocation taskManagerLocation;
                            NetworkEnvironment network;
                            TaskManagerConfiguration taskManagerConfig;
                            block27: {
                                block26: {
                                    LeaderRetrievalService lrs;
                                    long l;
                                    boolean preAllocateMemory;
                                    MemoryType memType;
                                    NetworkEnvironmentConfiguration netConfig;
                                    block23: {
                                        float fraction;
                                        block24: {
                                            block22: {
                                                KvStateServer kvStateServer;
                                                KvStateRegistry kvStateRegistry;
                                                TaskEventDispatcher taskEventDispatcher;
                                                ResultPartitionManager resultPartitionManager;
                                                LocalConnectionManager connectionManager;
                                                NetworkBufferPool networkBufferPool;
                                                InetSocketAddress taskManagerAddress;
                                                block20: {
                                                    block19: {
                                                        int numQueryThreads;
                                                        ConnectionManager connectionManager2;
                                                        block17: {
                                                            block16: {
                                                                Tuple4 tuple42;
                                                                tuple4 = this.parseTaskManagerConfiguration(configuration, taskManagerHostname, localTaskManagerCommunication);
                                                                if (tuple4 == null) break block15;
                                                                TaskManagerConfiguration taskManagerConfig2 = (TaskManagerConfiguration)tuple4._1();
                                                                NetworkEnvironmentConfiguration netConfig2 = (NetworkEnvironmentConfiguration)tuple4._2();
                                                                InetSocketAddress taskManagerAddress2 = (InetSocketAddress)tuple4._3();
                                                                MemoryType memType2 = (MemoryType)tuple4._4();
                                                                if (taskManagerConfig2 == null) break block15;
                                                                TaskManagerConfiguration taskManagerConfiguration = taskManagerConfig2;
                                                                if (netConfig2 == null) break block15;
                                                                NetworkEnvironmentConfiguration networkEnvironmentConfiguration = netConfig2;
                                                                if (taskManagerAddress2 == null) break block15;
                                                                InetSocketAddress inetSocketAddress = taskManagerAddress2;
                                                                if (memType2 == null) break block15;
                                                                MemoryType memoryType = memType2;
                                                                Tuple4 tuple43 = tuple42 = new Tuple4((Object)taskManagerConfiguration, (Object)networkEnvironmentConfiguration, (Object)inetSocketAddress, (Object)memoryType);
                                                                taskManagerConfig = (TaskManagerConfiguration)tuple43._1();
                                                                netConfig = (NetworkEnvironmentConfiguration)tuple43._2();
                                                                taskManagerAddress = (InetSocketAddress)tuple43._3();
                                                                memType = (MemoryType)tuple43._4();
                                                                this.checkTempDirs(taskManagerConfig.tmpDirPaths());
                                                                networkBufferPool = new NetworkBufferPool(netConfig.numNetworkBuffers(), netConfig.networkBufferSize(), netConfig.memoryType());
                                                                option = netConfig.nettyConfig();
                                                                if (!(option instanceof Some)) break block16;
                                                                Some some = (Some)option;
                                                                NettyConfig nettyConfig = (NettyConfig)some.x();
                                                                connectionManager2 = new NettyConnectionManager(nettyConfig);
                                                                break block17;
                                                            }
                                                            if (!None$.MODULE$.equals(option)) break block18;
                                                            connectionManager2 = new LocalConnectionManager();
                                                        }
                                                        connectionManager = connectionManager2;
                                                        resultPartitionManager = new ResultPartitionManager();
                                                        taskEventDispatcher = new TaskEventDispatcher();
                                                        kvStateRegistry = new KvStateRegistry();
                                                        Configuration tmConfig = taskManagerConfig.configuration();
                                                        bl = tmConfig.getBoolean(QueryableStateOptions.SERVER_ENABLE);
                                                        if (!bl) break block19;
                                                        int port = tmConfig.getInteger(QueryableStateOptions.SERVER_PORT);
                                                        int numNetworkThreads = tmConfig.getInteger(QueryableStateOptions.SERVER_NETWORK_THREADS);
                                                        if (numNetworkThreads == 0) {
                                                            numNetworkThreads = taskManagerConfig.numberOfSlots();
                                                        }
                                                        if ((numQueryThreads = tmConfig.getInteger(QueryableStateOptions.SERVER_ASYNC_QUERY_THREADS)) == 0) {
                                                            numQueryThreads = taskManagerConfig.numberOfSlots();
                                                        }
                                                        kvStateServer = new KvStateServer(taskManagerAddress.getAddress(), port, numNetworkThreads, numQueryThreads, kvStateRegistry, new DisabledKvStateRequestStats());
                                                        break block20;
                                                    }
                                                    if (bl) break block21;
                                                    kvStateServer = null;
                                                }
                                                KvStateServer kvStateServer2 = kvStateServer;
                                                network = new NetworkEnvironment(networkBufferPool, connectionManager, resultPartitionManager, taskEventDispatcher, kvStateRegistry, kvStateServer2, netConfig.ioMode(), netConfig.partitionRequestInitialBackoff(), netConfig.partitionRequestMaxBackoff());
                                                network.start();
                                                taskManagerLocation = new TaskManagerLocation(resourceID, taskManagerAddress.getAddress(), network.getConnectionManager().getDataPort());
                                                long configuredMemory = configuration.getLong("taskmanager.memory.size", -1L);
                                                this.checkConfigParameter(configuredMemory == -1L || configuredMemory > 0L, BoxesRunTime.boxToLong((long)configuredMemory), "taskmanager.memory.size", "MemoryManager needs at least one MB of memory. If you leave this config parameter empty, the system automatically pick a fraction of the available memory.");
                                                preAllocateMemory = configuration.getBoolean("taskmanager.memory.preallocate", false);
                                                if (configuredMemory <= 0L) break block22;
                                                if (preAllocateMemory) {
                                                    this.LOG().info((Function0)new Serializable(configuredMemory){
                                                        public static final long serialVersionUID = 0L;
                                                        private final long configuredMemory$1;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " MB for managed memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.configuredMemory$1)}));
                                                        }
                                                        {
                                                            this.configuredMemory$1 = configuredMemory$1;
                                                        }
                                                    });
                                                } else {
                                                    this.LOG().info((Function0)new Serializable(configuredMemory){
                                                        public static final long serialVersionUID = 0L;
                                                        private final long configuredMemory$1;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " MB, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.configuredMemory$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory will be allocated lazily."})).s((Seq)Nil$.MODULE$)).toString();
                                                        }
                                                        {
                                                            this.configuredMemory$1 = configuredMemory$1;
                                                        }
                                                    });
                                                }
                                                l = configuredMemory << 20;
                                                break block23;
                                            }
                                            fraction = configuration.getFloat("taskmanager.memory.fraction", 0.7f);
                                            this.checkConfigParameter(fraction > 0.0f && fraction < 1.0f, BoxesRunTime.boxToFloat((float)fraction), "taskmanager.memory.fraction", "MemoryManager fraction of the free memory must be between 0.0 and 1.0");
                                            MemoryType memoryType = memType;
                                            MemoryType memoryType2 = MemoryType.HEAP;
                                            if (memoryType != null ? !memoryType.equals(memoryType2) : memoryType2 != null) break block24;
                                            long relativeMemSize = (long)((double)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag() * (double)fraction);
                                            if (preAllocateMemory) {
                                                this.LOG().info((Function0)new Serializable(fraction, relativeMemSize){
                                                    public static final long serialVersionUID = 0L;
                                                    private final float fraction$1;
                                                    private final long relativeMemSize$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " of the currently free heap space for managed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heap memory (", " MB)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.relativeMemSize$1 >> 20))}))).toString();
                                                    }
                                                    {
                                                        this.fraction$1 = fraction$1;
                                                        this.relativeMemSize$1 = relativeMemSize$1;
                                                    }
                                                });
                                            } else {
                                                this.LOG().info((Function0)new Serializable(fraction, relativeMemSize){
                                                    public static final long serialVersionUID = 0L;
                                                    private final float fraction$1;
                                                    private final long relativeMemSize$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " of the currently free heap space "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " MB), memory will be allocated lazily."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.relativeMemSize$1 >> 20))}))).toString();
                                                    }
                                                    {
                                                        this.fraction$1 = fraction$1;
                                                        this.relativeMemSize$1 = relativeMemSize$1;
                                                    }
                                                });
                                            }
                                            l = relativeMemSize;
                                            break block23;
                                        }
                                        MemoryType memoryType = memType;
                                        MemoryType memoryType3 = MemoryType.OFF_HEAP;
                                        if (memoryType != null ? !memoryType.equals(memoryType3) : memoryType3 != null) break block25;
                                        long maxMemory = EnvironmentInformation.getMaxJvmHeapMemory();
                                        long directMemorySize = (long)((double)maxMemory / (1.0 - (double)fraction) * (double)fraction);
                                        if (preAllocateMemory) {
                                            this.LOG().info((Function0)new Serializable(fraction, directMemorySize){
                                                public static final long serialVersionUID = 0L;
                                                private final float fraction$1;
                                                private final long directMemorySize$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " of the maximum memory size for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"managed off-heap memory (", " MB)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.directMemorySize$1 >> 20))}))).toString();
                                                }
                                                {
                                                    this.fraction$1 = fraction$1;
                                                    this.directMemorySize$1 = directMemorySize$1;
                                                }
                                            });
                                        } else {
                                            this.LOG().info((Function0)new Serializable(fraction, directMemorySize){
                                                public static final long serialVersionUID = 0L;
                                                private final float fraction$1;
                                                private final long directMemorySize$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " of the maximum memory size "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " MB), memory will be allocated lazily."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.directMemorySize$1 >> 20))}))).toString();
                                                }
                                                {
                                                    this.fraction$1 = fraction$1;
                                                    this.directMemorySize$1 = directMemorySize$1;
                                                }
                                            });
                                        }
                                        l = directMemorySize;
                                    }
                                    long memorySize = l;
                                    try {
                                        memoryManager = new MemoryManager(memorySize, taskManagerConfig.numberOfSlots(), netConfig.networkBufferSize(), memType, preAllocateMemory);
                                        ioManager = new IOManagerAsync(taskManagerConfig.tmpDirPaths());
                                        option2 = leaderRetrievalServiceOption;
                                    }
                                    catch (OutOfMemoryError outOfMemoryError) {
                                        void var51_47;
                                        void var20_20;
                                        void var62_57 = var20_20;
                                        if (MemoryType.HEAP.equals(var62_57)) {
                                            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfMemory error (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outOfMemoryError.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while allocating the TaskManager heap memory (", " bytes)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)var51_47)}))).toString(), outOfMemoryError);
                                        }
                                        if (MemoryType.OFF_HEAP.equals(var62_57)) {
                                            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfMemory error (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outOfMemoryError.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while allocating the TaskManager off-heap memory (", " bytes). "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)var51_47)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try increasing the maximum direct memory (-XX:MaxDirectMemorySize)"})).s((Seq)Nil$.MODULE$)).toString(), outOfMemoryError);
                                        }
                                        throw outOfMemoryError;
                                    }
                                    if (!(option2 instanceof Some)) break block26;
                                    Some some = (Some)option2;
                                    leaderRetrievalService = lrs = (LeaderRetrievalService)some.x();
                                    break block27;
                                }
                                if (!None$.MODULE$.equals(option2)) break block28;
                                leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration, true);
                            }
                            LeaderRetrievalService leaderRetrievalService2 = leaderRetrievalService;
                            MetricRegistry metricsRegistry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration(configuration));
                            return new Tuple7((Object)taskManagerConfig, (Object)taskManagerLocation, (Object)memoryManager, (Object)ioManager, (Object)network, (Object)leaderRetrievalService2, (Object)metricsRegistry);
                        }
                        throw new MatchError(option2);
                    }
                    throw new RuntimeException("No supported memory type detected.");
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple4);
    }

    public ActorRef getTaskManagerRemoteReference(String taskManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getActorRefFuture(taskManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the TaskManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to TaskManager at ").append((Object)taskManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public Tuple4<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InetSocketAddress, MemoryType> parseTaskManagerConfiguration(Configuration configuration, String taskManagerHostname, boolean localTaskManagerCommunication) throws IllegalArgumentException {
        MemoryType memoryType;
        block23: {
            block24: {
                Duration pause;
                block17: {
                    Duration pause2;
                    block18: {
                        Duration pause3;
                        block19: {
                            FiniteDuration refusedRegistrationPause;
                            String syncOrAsync;
                            MemoryType memType;
                            int pageSize;
                            int numNetworkBuffers;
                            int slots;
                            InetSocketAddress taskManagerInetSocketAddress;
                            block22: {
                                block20: {
                                    block21: {
                                        int n;
                                        int dataport = configuration.getInteger("taskmanager.data.port", 0);
                                        this.checkConfigParameter(dataport >= 0, BoxesRunTime.boxToInteger((int)dataport), "taskmanager.data.port", "Leave config parameter empty or use 0 to let the system choose a port automatically.");
                                        InetAddress taskManagerAddress = InetAddress.getByName(taskManagerHostname);
                                        taskManagerInetSocketAddress = new InetSocketAddress(taskManagerAddress, dataport);
                                        int n2 = configuration.getInteger("taskmanager.numberOfTaskSlots", 1);
                                        switch (n2) {
                                            default: {
                                                n = n2;
                                                break;
                                            }
                                            case -1: {
                                                n = 1;
                                            }
                                        }
                                        slots = n;
                                        this.checkConfigParameter(slots >= 1, BoxesRunTime.boxToInteger((int)slots), "taskmanager.numberOfTaskSlots", "Number of task slots must be at least one.");
                                        numNetworkBuffers = configuration.getInteger("taskmanager.network.numberOfBuffers", 2048);
                                        this.checkConfigParameter(numNetworkBuffers > 0, BoxesRunTime.boxToInteger((int)numNetworkBuffers), "taskmanager.network.numberOfBuffers", this.checkConfigParameter$default$4());
                                        pageSize = configuration.getInteger("taskmanager.memory.segment-size", 32768);
                                        this.checkConfigParameter(pageSize >= MemoryManager.MIN_PAGE_SIZE, BoxesRunTime.boxToInteger((int)pageSize), "taskmanager.memory.segment-size", new StringBuilder().append((Object)"Minimum memory segment size is ").append((Object)BoxesRunTime.boxToInteger((int)MemoryManager.MIN_PAGE_SIZE)).toString());
                                        this.checkConfigParameter(MathUtils.isPowerOf2((long)pageSize), BoxesRunTime.boxToInteger((int)pageSize), "taskmanager.memory.segment-size", "Memory segment size must be a power of 2.");
                                        memoryType = memType = configuration.getBoolean("taskmanager.memory.off-heap", false) ? MemoryType.OFF_HEAP : MemoryType.HEAP;
                                        if (!MemoryType.HEAP.equals(memoryType)) break block20;
                                        if (!MemorySegmentFactory.initializeIfNotInitialized((MemorySegmentFactory.Factory)HeapMemorySegment.FACTORY)) break block21;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block22;
                                    }
                                    throw new Exception("Memory type is set to heap memory, but memory segment factory has been initialized for off-heap memory segments");
                                }
                                if (!MemoryType.OFF_HEAP.equals(memoryType)) break block23;
                                if (!MemorySegmentFactory.initializeIfNotInitialized((MemorySegmentFactory.Factory)HybridMemorySegment.FACTORY)) break block24;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            String[] tmpDirs = configuration.getString("taskmanager.tmp.dirs", ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH).split(new StringBuilder().append((Object)",|").append((Object)File.pathSeparator).toString());
                            None$ nettyConfig = localTaskManagerCommunication ? None$.MODULE$ : new Some((Object)new NettyConfig(taskManagerInetSocketAddress.getAddress(), taskManagerInetSocketAddress.getPort(), pageSize, slots, configuration));
                            String string = syncOrAsync = configuration.getString("taskmanager.network.defaultIOMode", "sync");
                            String string2 = "async";
                            IOManager.IOMode ioMode = !(string != null ? !string.equals(string2) : string2 != null) ? IOManager.IOMode.ASYNC : IOManager.IOMode.SYNC;
                            int initialRequestBackoff = configuration.getInteger(TaskManagerOptions.NETWORK_REQUEST_BACKOFF_INITIAL);
                            int maxRequestBackoff = configuration.getInteger(TaskManagerOptions.NETWORK_REQUEST_BACKOFF_MAX);
                            NetworkEnvironmentConfiguration networkConfig = new NetworkEnvironmentConfiguration(numNetworkBuffers, pageSize, memType, ioMode, initialRequestBackoff, maxRequestBackoff, (Option<NettyConfig>)nettyConfig);
                            FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
                            this.LOG().info((Function0)new Serializable(timeout){
                                public static final long serialVersionUID = 0L;
                                private final FiniteDuration timeout$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Messages between TaskManager and JobManager have a max timeout of ").append((Object)this.timeout$2).toString();
                                }
                                {
                                    this.timeout$2 = timeout$2;
                                }
                            });
                            long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
                            Duration maxRegistrationDuration = Duration$.MODULE$.apply(configuration.getString("taskmanager.maxRegistrationDuration", "Inf"));
                            None$ finiteRegistrationDuration = maxRegistrationDuration.isFinite() ? new Some((Object)((FiniteDuration)maxRegistrationDuration)) : None$.MODULE$;
                            pause = Duration$.MODULE$.apply(configuration.getString("taskmanager.initial-registration-pause", "500 ms"));
                            if (!pause.isFinite()) break block17;
                            FiniteDuration initialRegistrationPause = (FiniteDuration)pause;
                            pause2 = Duration$.MODULE$.apply(configuration.getString("taskmanager.max-registration-pause", "30 s"));
                            if (!pause2.isFinite()) break block18;
                            FiniteDuration maxRegistrationPause = (FiniteDuration)pause2;
                            try {
                                pause3 = Duration$.MODULE$.apply(configuration.getString("taskmanager.refused-registration-pause", "10 s"));
                                if (!pause3.isFinite()) break block19;
                                refusedRegistrationPause = (FiniteDuration)pause3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", numberFormatException);
                            }
                            TaskManagerConfiguration taskManagerConfig = new TaskManagerConfiguration(tmpDirs, cleanupInterval, timeout, (Option<FiniteDuration>)finiteRegistrationDuration, slots, configuration, initialRegistrationPause, maxRegistrationPause, refusedRegistrationPause);
                            return new Tuple4((Object)taskManagerConfig, (Object)networkConfig, (Object)taskManagerInetSocketAddress, (Object)memType);
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The refused registration pause must be finite: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pause3})));
                    }
                    try {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The maximum registration pause must be finite: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pause2})));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", numberFormatException);
                    }
                }
                try {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The initial registration pause must be finite: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pause})));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid format for parameter taskmanager.initial-registration-pause", numberFormatException);
                }
            }
            throw new Exception("Memory type is set to off-heap memory, but memory segment factory has been initialized for heap memory segments");
        }
        throw new MatchError((Object)memoryType);
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid format for '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"akka.ask.timeout"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use formats like '50 s' or '1 min' to specify the timeout."})).s((Seq)Nil$.MODULE$)).toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.maxRegistrationDuration", numberFormatException);
        }
    }

    public Tuple3<String, String, Object> getAndCheckJobManagerAddress(Configuration configuration) {
        String protocol = AkkaUtils$.MODULE$.getAkkaProtocol(configuration);
        String hostname = configuration.getString("jobmanager.rpc.address", null);
        int port = configuration.getInteger("jobmanager.rpc.port", 6123);
        if (hostname == null) {
            throw new Exception("Config parameter 'jobmanager.rpc.address' is missing (hostname/address of JobManager to connect to).");
        }
        if (port <= 0 || port >= 65536) {
            throw new Exception(new StringBuilder().append((Object)"Invalid value for 'jobmanager.rpc.port' (port of the JobManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)".  it must be great than 0 and less than 65536.").toString());
        }
        return new Tuple3((Object)protocol, (Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
    }

    private void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (condition) {
            return;
        }
        throw new IllegalConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid configuration value for '", "' : ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, parameter, errorMessage})));
    }

    private String checkConfigParameter$default$4() {
        return "";
    }

    private void checkTempDirs(String[] tmpDirs) throws IOException {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tmpDirs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, Object> x0$5) {
                String dir;
                Tuple2<String, Object> tuple2 = x0$5;
                if (tuple2 != null && (dir = (String)tuple2._1()) != null) {
                    String string = dir;
                    File file = new File(string);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            if (file.canWrite()) {
                                BoxedUnit boxedUnit;
                                if (TaskManager$.MODULE$.LOG().isInfoEnabled()) {
                                    long totalSpaceGb = file.getTotalSpace() >> 30;
                                    long usableSpaceGb = file.getUsableSpace() >> 30;
                                    double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * (double)100;
                                    String path = file.getAbsolutePath();
                                    TaskManager$.MODULE$.LOG().info((Function0)new Serializable(this, totalSpaceGb, usableSpaceGb, usablePercentage, path){
                                        public static final long serialVersionUID = 0L;
                                        private final long totalSpaceGb$1;
                                        private final long usableSpaceGb$1;
                                        private final double usablePercentage$1;
                                        private final String path$1;

                                        public final String apply() {
                                            String arg$macro$1 = this.path$1;
                                            Long arg$macro$2 = BoxesRunTime.boxToLong((long)this.totalSpaceGb$1);
                                            Long arg$macro$3 = BoxesRunTime.boxToLong((long)this.usableSpaceGb$1);
                                            double arg$macro$4 = this.usablePercentage$1;
                                            return new StringBuilder().append((Object)new StringOps("Temporary file directory '%s': total %s GB, ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}))).append((Object)new StringOps("usable %s GB (%.2f%% usable)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)}))).toString();
                                        }
                                        {
                                            this.totalSpaceGb$1 = totalSpaceGb$1;
                                            this.usableSpaceGb$1 = usableSpaceGb$1;
                                            this.usablePercentage$1 = usablePercentage$1;
                                            this.path$1 = path$1;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not writable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                    }
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                }
                if (tuple2 != null) {
                    int id = tuple2._2$mcI$sp();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory #", " is null."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private TaskManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(TaskManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.TASK_MANAGER_NAME = "taskmanager";
        this.MAX_STARTUP_CONNECT_TIME = 120000L;
        this.STARTUP_CONNECT_LOG_SUPPRESS = 10000L;
        this.HEARTBEAT_INTERVAL = new package.DurationInt(package$.MODULE$.DurationInt(5000)).milliseconds();
    }
}

