/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerLocation
implements Comparable<TaskManagerLocation>,
Serializable {
    private static final long serialVersionUID = -8254407801276350716L;
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerLocation.class);
    private final ResourceID resourceID;
    private final InetAddress inetAddress;
    private final String fqdnHostName;
    private final String hostName;
    private final int dataPort;
    private final String stringRepresentation;

    public TaskManagerLocation(ResourceID resourceID, InetAddress inetAddress, int dataPort) {
        String fqdnHostName;
        Preconditions.checkArgument((dataPort > 0 || dataPort == -1 ? 1 : 0) != 0, (Object)"dataPort must be > 0, or -1 (local)");
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.inetAddress = (InetAddress)Preconditions.checkNotNull((Object)inetAddress);
        this.dataPort = dataPort;
        try {
            fqdnHostName = this.inetAddress.getCanonicalHostName();
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine the canonical hostname. Input split assignment (such as for HDFS files) may be non-local when the canonical hostname is missing.");
            LOG.debug("getCanonicalHostName() Exception:", t);
            fqdnHostName = this.inetAddress.getHostAddress();
        }
        this.fqdnHostName = fqdnHostName;
        if (this.fqdnHostName.equals(this.inetAddress.getHostAddress())) {
            this.hostName = this.fqdnHostName;
            LOG.warn("No hostname could be resolved for the IP address {}, using IP address as host name. Local input split assignment (such as for HDFS files) may be impacted.", (Object)this.inetAddress.getHostAddress());
        } else {
            this.hostName = NetUtils.getHostnameFromFQDN((String)this.fqdnHostName);
        }
        this.stringRepresentation = String.format("%s @ %s (dataPort=%d)", resourceID, fqdnHostName, dataPort);
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public int dataPort() {
        return this.dataPort;
    }

    public InetAddress address() {
        return this.inetAddress;
    }

    public String addressString() {
        return this.inetAddress.toString();
    }

    public String getFQDNHostname() {
        return this.fqdnHostName;
    }

    public String getHostname() {
        return this.hostName;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == TaskManagerLocation.class) {
            TaskManagerLocation that = (TaskManagerLocation)obj;
            return this.resourceID.equals(that.resourceID) && this.inetAddress.equals(that.inetAddress) && this.dataPort == that.dataPort;
        }
        return false;
    }

    public int hashCode() {
        return this.resourceID.hashCode() + 17 * this.inetAddress.hashCode() + 129 * this.dataPort;
    }

    @Override
    public int compareTo(@Nonnull TaskManagerLocation o) {
        byte[] otherAddress;
        int resourceIdCmp = this.resourceID.getResourceIdString().compareTo(o.resourceID.getResourceIdString());
        if (resourceIdCmp != 0) {
            return resourceIdCmp;
        }
        byte[] thisAddress = this.inetAddress.getAddress();
        if (thisAddress.length < (otherAddress = o.inetAddress.getAddress()).length) {
            return -1;
        }
        if (thisAddress.length > otherAddress.length) {
            return 1;
        }
        for (int i = 0; i < thisAddress.length; ++i) {
            byte tb = thisAddress[i];
            byte ob = otherAddress[i];
            if (tb < ob) {
                return -1;
            }
            if (tb <= ob) continue;
            return 1;
        }
        if (this.dataPort < o.dataPort) {
            return -1;
        }
        if (this.dataPort > o.dataPort) {
            return 1;
        }
        return 0;
    }
}

