/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

public class TaskManagerRuntimeInfo
implements Serializable {
    private static final long serialVersionUID = 5598219619760274072L;
    private final String hostname;
    private final Configuration configuration;
    private final String[] tmpDirectories;

    public TaskManagerRuntimeInfo(String hostname, Configuration configuration, String tmpDirectory) {
        this(hostname, configuration, new String[]{tmpDirectory});
    }

    public TaskManagerRuntimeInfo(String hostname, Configuration configuration, String[] tmpDirectories) {
        Preconditions.checkArgument((tmpDirectories.length > 0 ? 1 : 0) != 0);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.tmpDirectories = tmpDirectories;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }
}

