/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u00111\u0001B\u0001\u0007e\u0016lw\u000e^3\u000b\u0003\u0015\tA!Y6lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JD\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0001F\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\r\u0011{WO\u00197f\u0011!I\u0002A!A!\u0002\u0013)\u0012A\u0003;ie\u0016\u001c\bn\u001c7eA!A1\u0004\u0001BC\u0002\u0013\u0005A$A\u0007nCb\u001c\u0016-\u001c9mKNK'0Z\u000b\u0002;A\u0011\u0011BH\u0005\u0003?)\u00111!\u00138u\u0011!\t\u0003A!A!\u0002\u0013i\u0012AD7bqN\u000bW\u000e\u001d7f'&TX\r\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001&!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0005ekJ\fG/[8o\u0015\tQ#\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0014\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Aa\u0006\u0001B\u0001B\u0003%Q%\u0001\tnS:\u001cF\u000f\u001a#fm&\fG/[8oA!A\u0001\u0007\u0001BC\u0002\u0013\u0005A%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u001aC\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u0001%\u0003Y1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,5\u000f^5nCR,\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002/\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b1B\u001d\u0002\u000b\rdwnY6\u0011\u0005i\"eBA\u001eC\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I!a\u0011\u0002\u0002\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JL!!\u0012$\u0003\u000b\rcwnY6\u000b\u0005\r\u0013\u0001\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0004K\u001b:{\u0005+\u0015\u000b\u0003\u00172\u0003\"a\u0004\u0001\t\u000ba:\u00059A\u001d\t\u000bM9\u0005\u0019A\u000b\t\u000bm9\u0005\u0019A\u000f\t\u000b\r:\u0005\u0019A\u0013\t\u000bA:\u0005\u0019A\u0013\t\u000bQ:\u0005\u0019A\u0013\t\u000b!\u0003A\u0011A*\u0015\u0007-#v\fC\u0003V%\u0002\u0007a+\u0001\u0004d_:4\u0017n\u001a\t\u0003/vk\u0011\u0001\u0017\u0006\u0003+fS!AW.\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001X\u0001\u0004G>l\u0017B\u00010Y\u0005\u0019\u0019uN\u001c4jO\")\u0001M\u0015a\u0001C\u0006\u0011QM\u001e\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0012\tQ!\u001a<f]RL!AZ2\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\u001c\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u000391\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,\u0012A\u001b\t\u0003\u001f-L!\u0001\u001c\u0002\u0003!!+\u0017M\u001d;cK\u0006$\b*[:u_JL\bB\u00028\u0001A\u0003%!.A\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;!\u0011\u001d\u0001\bA1A\u0005\nE\fa$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:f\u001b&dG.[:\u0016\u0003I\u0004\"!C:\n\u0005QT!\u0001\u0002'p]\u001eDaA\u001e\u0001!\u0002\u0013\u0011\u0018aH1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK6KG\u000e\\5tA\u0019!\u0001\u0010\u0001$z\u0005\u0015\u0019F/\u0019;f'\u00119\bB_?\u0011\u0005%Y\u0018B\u0001?\u000b\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0003@\n\u0005}T!\u0001D*fe&\fG.\u001b>bE2,\u0007\"CA\u0002o\nU\r\u0011\"\u0001j\u0003\u001dA\u0017n\u001d;pefD\u0011\"a\u0002x\u0005#\u0005\u000b\u0011\u00026\u0002\u0011!L7\u000f^8ss\u0002B!\"a\u0003x\u0005+\u0007I\u0011AA\u0007\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002\u0010A!\u0011\"!\u0005s\u0013\r\t\u0019B\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0015\u0005]qO!E!\u0002\u0013\ty!\u0001\u0006uS6,7\u000f^1na\u0002Ba\u0001S<\u0005\u0002\u0005mACBA\u000f\u0003C\t\u0019\u0003E\u0002\u0002 ]l\u0011\u0001\u0001\u0005\b\u0003\u0007\tI\u00021\u0001k\u0011!\tY!!\u0007A\u0002\u0005=\u0001\"CA\u0014o\u0006\u0005I\u0011AA\u0015\u0003\u0011\u0019w\u000e]=\u0015\r\u0005u\u00111FA\u0017\u0011%\t\u0019!!\n\u0011\u0002\u0003\u0007!\u000e\u0003\u0006\u0002\f\u0005\u0015\u0002\u0013!a\u0001\u0003\u001fA\u0011\"!\rx#\u0003%\t!a\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0007\u0016\u0004U\u0006]2FAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r#\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005-s/%A\u0005\u0002\u00055\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001fRC!a\u0004\u00028!I\u00111K<\u0002\u0002\u0013\u0005\u0013QK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005Y\u0006twM\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'a\u0017\u0003\rM#(/\u001b8h\u0011!\tIg^A\u0001\n\u0003a\u0012\u0001\u00049s_\u0012,8\r^!sSRL\b\"CA7o\u0006\u0005I\u0011AA8\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001d\u0002xA\u0019\u0011\"a\u001d\n\u0007\u0005U$BA\u0002B]fD\u0011\"!\u001f\u0002l\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013\u0007C\u0005\u0002~]\f\t\u0011\"\u0011\u0002\u0000\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0002B1\u00111QAE\u0003cj!!!\"\u000b\u0007\u0005\u001d%\"\u0001\u0006d_2dWm\u0019;j_:LA!a#\u0002\u0006\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0010^\f\t\u0011\"\u0001\u0002\u0012\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0014\u0006e\u0005cA\u0005\u0002\u0016&\u0019\u0011q\u0013\u0006\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011PAG\u0003\u0003\u0005\r!!\u001d\t\u0013\u0005uu/!A\u0005B\u0005}\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003uA\u0011\"a)x\u0003\u0003%\t%!*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0016\t\u0013\u0005%v/!A\u0005B\u0005-\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0014\u00065\u0006BCA=\u0003O\u000b\t\u00111\u0001\u0002r\u001dI\u0011\u0011\u0017\u0001\u0002\u0002#%\u00111W\u0001\u0006'R\fG/\u001a\t\u0005\u0003?\t)L\u0002\u0005y\u0001\u0005\u0005\t\u0012BA\\'\u0015\t),!/~!%\tY,!1k\u0003\u001f\ti\"\u0004\u0002\u0002>*\u0019\u0011q\u0018\u0006\u0002\u000fI,h\u000e^5nK&!\u00111YA_\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u0011\u0006UF\u0011AAd)\t\t\u0019\f\u0003\u0006\u0002$\u0006U\u0016\u0011!C#\u0003KC!\"!4\u00026\u0006\u0005I\u0011QAh\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ti\"!5\u0002T\"9\u00111AAf\u0001\u0004Q\u0007\u0002CA\u0006\u0003\u0017\u0004\r!a\u0004\t\u0015\u0005]\u0017QWA\u0001\n\u0003\u000bI.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u00171\u001d\t\u0006\u0013\u0005E\u0011Q\u001c\t\u0007\u0013\u0005}'.a\u0004\n\u0007\u0005\u0005(B\u0001\u0004UkBdWM\r\u0005\u000b\u0003K\f).!AA\u0002\u0005u\u0011a\u0001=%a!I\u0011\u0011\u001e\u0001C\u0002\u0013%\u00111^\u0001\u0006gR\fG/Z\u000b\u0003\u0003[\u0004b!a<\u0002|\u0006uQBAAy\u0015\u0011\t\u00190!>\u0002\r\u0005$x.\\5d\u0015\rQ\u0013q\u001f\u0006\u0005\u0003s\fy&\u0001\u0003vi&d\u0017\u0002BA\u007f\u0003c\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0002n\u000611\u000f^1uK\u0002BqA!\u0002\u0001\t\u0003\u00129!A\u0006jg\u00063\u0018-\u001b7bE2,WCAAJ\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u0017!B!a%\u0003\u000e!9\u00111\u0002B\u0005\u0001\u0004\u0011\bb\u0002B\t\u0001\u0011\u0005#qA\u0001\rSNluN\\5u_JLgn\u001a\u0005\b\u0005+\u0001AQ\tB\f\u0003%AW-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0003\u001aA\u0019\u0011Ba\u0007\n\u0007\tu!B\u0001\u0003V]&$\b\u0006\u0002B\n\u0005C\u0001BAa\t\u0003&5\u0011\u0011\u0011I\u0005\u0005\u0005O\t\tEA\u0004uC&d'/Z2\t\r\t-\u0002\u0001\"\u0001\u0015\u0003\r\u0001\b.\u001b\u0005\b\u0005W\u0001A\u0011\u0002B\u0018)\r)\"\u0011\u0007\u0005\b\u0003\u0017\u0011i\u00031\u0001s\u0011!\u0011Y\u0003\u0001C\u0001\t\tUBcB\u000b\u00038\tm\"q\b\u0005\b\u0005s\u0011\u0019\u00041\u0001s\u0003!!\u0018.\\3ES\u001a4\u0007b\u0002B\u001f\u0005g\u0001\r!F\u0001\u0005[\u0016\fg\u000eC\u0004\u0003B\tM\u0002\u0019A\u000b\u0002\u0019M$H\rR3wS\u0006$\u0018n\u001c8\t\u0011\t\u0015\u0003A1A\u0005\nE\fQ#\\5o'R$G)\u001a<jCRLwN\\'jY2L7\u000fC\u0004\u0003J\u0001\u0001\u000b\u0011\u0002:\u0002-5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\u0002BqA!\u0014\u0001\t\u0013\u0011y%A\ff]N,(/\u001a,bY&$7\u000b\u001e3EKZL\u0017\r^5p]R\u0019QC!\u0015\t\u000f\t\u0005#1\na\u0001+\u0001")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;
    private volatile PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State$lzycompute() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.akka$remote$PhiAccrualFailureDetector$$State$module != null) return this.akka$remote$PhiAccrualFailureDetector$$State$module;
            this.akka$remote$PhiAccrualFailureDetector$$State$module = new PhiAccrualFailureDetector$State$(this);
            return this.akka$remote$PhiAccrualFailureDetector$$State$module;
        }
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State() {
        return this.akka$remote$PhiAccrualFailureDetector$$State$module == null ? this.akka$remote$PhiAccrualFailureDetector$$State$lzycompute() : this.akka$remote$PhiAccrualFailureDetector$$State$module;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        Option<Object> option;
        block3: {
            State newState;
            State oldState;
            do {
                HeartbeatHistory heartbeatHistory;
                long timestamp = this.clock.apply$mcJ$sp();
                oldState = this.state().get();
                option = oldState.timestamp();
                if (None$.MODULE$.equals(option)) {
                    heartbeatHistory = this.firstHeartbeat();
                } else {
                    if (!(option instanceof Some)) break block3;
                    Some some = (Some)option;
                    long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.x());
                    long interval = timestamp - latestTimestamp;
                    heartbeatHistory = this.isAvailable(timestamp) ? oldState.history().$colon$plus(interval) : oldState.history();
                }
                HeartbeatHistory newHistory = heartbeatHistory;
                newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
            } while (!this.state().compareAndSet(oldState, newState));
            return;
        }
        throw new MatchError(option);
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.threshold must be > 0";
            }
        });
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.max-sample-size must be > 0";
            }
        });
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.min-std-deviation must be > 0";
            }
        });
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.acceptable-heartbeat-pause must be >= 0";
            }
        });
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.heartbeat-interval must be > 0";
            }
        });
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.state = new AtomicReference<State>(this.akka$remote$PhiAccrualFailureDetector$$State().apply(this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), FailureDetector$.MODULE$.defaultClock());
    }

    public final class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        private final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.$outer, history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.timestamp();
                    break;
                }
                case 0: {
                    object = this.history();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

