/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.util.Preconditions;

public class ContaineredTaskManagerParameters
implements Serializable {
    private static final long serialVersionUID = -3096987654278064670L;
    private final long totalContainerMemoryMB;
    private final long taskManagerHeapSizeMB;
    private final long taskManagerDirectMemoryLimitMB;
    private final int numSlots;
    private final HashMap<String, String> taskManagerEnv;

    public ContaineredTaskManagerParameters(long totalContainerMemoryMB, long taskManagerHeapSizeMB, long taskManagerDirectMemoryLimitMB, int numSlots, HashMap<String, String> taskManagerEnv) {
        this.totalContainerMemoryMB = totalContainerMemoryMB;
        this.taskManagerHeapSizeMB = taskManagerHeapSizeMB;
        this.taskManagerDirectMemoryLimitMB = taskManagerDirectMemoryLimitMB;
        this.numSlots = numSlots;
        this.taskManagerEnv = taskManagerEnv;
    }

    public long taskManagerTotalMemoryMB() {
        return this.totalContainerMemoryMB;
    }

    public long taskManagerHeapSizeMB() {
        return this.taskManagerHeapSizeMB;
    }

    public long taskManagerDirectMemoryLimitMB() {
        return this.taskManagerDirectMemoryLimitMB;
    }

    public int numSlots() {
        return this.numSlots;
    }

    public Map<String, String> taskManagerEnv() {
        return this.taskManagerEnv;
    }

    public String toString() {
        return "TaskManagerParameters {totalContainerMemory=" + this.totalContainerMemoryMB + ", taskManagerHeapSize=" + this.taskManagerHeapSizeMB + ", taskManagerDirectMemoryLimit=" + this.taskManagerDirectMemoryLimitMB + ", numSlots=" + this.numSlots + ", taskManagerEnv=" + this.taskManagerEnv + '}';
    }

    public static long calculateCutoffMB(Configuration config, long containerMemoryMB) {
        Preconditions.checkArgument((containerMemoryMB > 0L ? 1 : 0) != 0);
        float memoryCutoffRatio = config.getFloat(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO);
        if (memoryCutoffRatio >= 1.0f || memoryCutoffRatio <= 0.0f) {
            throw new IllegalArgumentException("The configuration value '" + ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO.key() + "' must be between 0 and 1. Value given=" + memoryCutoffRatio);
        }
        int minCutoff = config.getInteger(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN);
        if ((long)minCutoff >= containerMemoryMB) {
            throw new IllegalArgumentException("The configuration value '" + ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN.key() + "'='" + minCutoff + "' is larger than the total container memory " + containerMemoryMB);
        }
        long cutoff = (long)((float)containerMemoryMB * memoryCutoffRatio);
        if (cutoff < (long)minCutoff) {
            cutoff = minCutoff;
        }
        return cutoff;
    }

    public static ContaineredTaskManagerParameters create(Configuration config, long containerMemoryMB, int numSlots) {
        long cutoffMB = ContaineredTaskManagerParameters.calculateCutoffMB(config, containerMemoryMB);
        long heapSizeMB = TaskManagerServices.calculateHeapSizeMB(containerMemoryMB - cutoffMB, config);
        long offHeapSizeMB = containerMemoryMB - heapSizeMB;
        HashMap<String, String> envVars = new HashMap<String, String>();
        String prefix = "containerized.taskmanager.env.";
        for (String key : config.keySet()) {
            if (!key.startsWith("containerized.taskmanager.env.") || key.length() <= "containerized.taskmanager.env.".length()) continue;
            String envVarKey = key.substring("containerized.taskmanager.env.".length());
            envVars.put(envVarKey, config.getString(key, null));
        }
        return new ContaineredTaskManagerParameters(containerMemoryMB, heapSizeMB, offHeapSizeMB, numSlots, envVars);
    }
}

