/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

public class Executors {
    private static final Logger LOG = LoggerFactory.getLogger(Executors.class);

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    public static ExecutionContext directExecutionContext() {
        return DirectExecutionContext.INSTANCE;
    }

    private static class DirectExecutionContext
    implements ExecutionContext {
        static final DirectExecutionContext INSTANCE = new DirectExecutionContext();

        private DirectExecutionContext() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }

        public void reportFailure(Throwable cause) {
            throw new IllegalStateException("Error in direct execution context.", cause);
        }

        public ExecutionContext prepare() {
            return this;
        }
    }

    private static class DirectExecutor
    implements Executor {
        static final DirectExecutor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            command.run();
        }
    }
}

