/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.util.Preconditions;

public class FsNegativeRunningJobsRegistry
implements RunningJobsRegistry {
    private static final String DONE_PREFIX = ".job_complete_";
    private static final String RUNNING_PREFIX = ".job_runing_";
    private final FileSystem fileSystem;
    private final Path basePath;

    public FsNegativeRunningJobsRegistry(Path workingDirectory) throws IOException {
        this(workingDirectory.getFileSystem(), workingDirectory);
    }

    public FsNegativeRunningJobsRegistry(FileSystem fileSystem, Path workingDirectory) throws IOException {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem, (String)"fileSystem");
        this.basePath = (Path)Preconditions.checkNotNull((Object)workingDirectory, (String)"workingDirectory");
        Path testFile = new Path(workingDirectory, ".registry_test");
        try {
            this.createFile(testFile, false);
        }
        catch (IOException e) {
            throw new IOException("Unable to write to working directory: " + workingDirectory, e);
        }
        finally {
            fileSystem.delete(testFile, false);
        }
    }

    @Override
    public void setJobRunning(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID, (String)"jobID");
        Path filePath = this.createMarkerFilePath(RUNNING_PREFIX, jobID);
        this.createFile(filePath, true);
    }

    @Override
    public void setJobFinished(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID, (String)"jobID");
        Path filePath = this.createMarkerFilePath(DONE_PREFIX, jobID);
        this.createFile(filePath, true);
    }

    @Override
    public RunningJobsRegistry.JobSchedulingStatus getJobSchedulingStatus(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID, (String)"jobID");
        if (this.fileSystem.exists(this.createMarkerFilePath(DONE_PREFIX, jobID))) {
            return RunningJobsRegistry.JobSchedulingStatus.DONE;
        }
        if (this.fileSystem.exists(this.createMarkerFilePath(RUNNING_PREFIX, jobID))) {
            return RunningJobsRegistry.JobSchedulingStatus.RUNNING;
        }
        return RunningJobsRegistry.JobSchedulingStatus.PENDING;
    }

    @Override
    public void clearJob(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID, (String)"jobID");
        Path runningFilePath = this.createMarkerFilePath(RUNNING_PREFIX, jobID);
        Path doneFilePath = this.createMarkerFilePath(DONE_PREFIX, jobID);
        try {
            this.fileSystem.delete(runningFilePath, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            this.fileSystem.delete(doneFilePath, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private Path createMarkerFilePath(String prefix, JobID jobId) {
        return new Path(this.basePath, prefix + jobId.toString());
    }

    private void createFile(Path path, boolean overwrite) throws IOException {
        FileSystem.WriteMode writeMode = overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        try (FSDataOutputStream out = this.fileSystem.create(path, writeMode);){
            out.write(42);
        }
    }
}

