/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;

public class RoundRobinChannelSelector<T extends IOReadableWritable>
implements ChannelSelector<T> {
    private final int[] nextChannelToSendTo = new int[1];

    public RoundRobinChannelSelector() {
        this.nextChannelToSendTo[0] = 0;
    }

    @Override
    public int[] selectChannels(T record, int numberOfOutputChannels) {
        this.nextChannelToSendTo[0] = this.nextChannelToSendTo[0] + 1;
        int newChannel = this.nextChannelToSendTo[0];
        if (newChannel >= numberOfOutputChannels) {
            this.nextChannelToSendTo[0] = 0;
        }
        return this.nextChannelToSendTo;
    }
}

