/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.Collection;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class InputGateMetrics {
    private final SingleInputGate inputGate;

    private InputGateMetrics(SingleInputGate inputGate) {
        this.inputGate = (SingleInputGate)Preconditions.checkNotNull((Object)inputGate);
    }

    long refreshAndGetTotal() {
        long total = 0L;
        for (InputChannel channel : this.inputGate.getInputChannels().values()) {
            if (!(channel instanceof RemoteInputChannel)) continue;
            RemoteInputChannel rc = (RemoteInputChannel)channel;
            total += (long)rc.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return total;
    }

    int refreshAndGetMin() {
        int min = Integer.MAX_VALUE;
        Collection<InputChannel> channels = this.inputGate.getInputChannels().values();
        for (InputChannel channel : channels) {
            if (!(channel instanceof RemoteInputChannel)) continue;
            RemoteInputChannel rc = (RemoteInputChannel)channel;
            int size = rc.unsynchronizedGetNumberOfQueuedBuffers();
            min = Math.min(min, size);
        }
        if (min == Integer.MAX_VALUE) {
            return 0;
        }
        return min;
    }

    int refreshAndGetMax() {
        int max = 0;
        for (InputChannel channel : this.inputGate.getInputChannels().values()) {
            if (!(channel instanceof RemoteInputChannel)) continue;
            RemoteInputChannel rc = (RemoteInputChannel)channel;
            int size = rc.unsynchronizedGetNumberOfQueuedBuffers();
            max = Math.max(max, size);
        }
        return max;
    }

    float refreshAndGetAvg() {
        long total = 0L;
        int count = 0;
        for (InputChannel channel : this.inputGate.getInputChannels().values()) {
            if (!(channel instanceof RemoteInputChannel)) continue;
            RemoteInputChannel rc = (RemoteInputChannel)channel;
            int size = rc.unsynchronizedGetNumberOfQueuedBuffers();
            total += (long)size;
            ++count;
        }
        return count == 0 ? 0.0f : (float)total / (float)count;
    }

    private Gauge<Long> getTotalQueueLenGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return InputGateMetrics.this.refreshAndGetTotal();
            }
        };
    }

    private Gauge<Integer> getMinQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return InputGateMetrics.this.refreshAndGetMin();
            }
        };
    }

    private Gauge<Integer> getMaxQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return InputGateMetrics.this.refreshAndGetMax();
            }
        };
    }

    private Gauge<Float> getAvgQueueLenGauge() {
        return new Gauge<Float>(){

            public Float getValue() {
                return Float.valueOf(InputGateMetrics.this.refreshAndGetAvg());
            }
        };
    }

    public static void registerQueueLengthMetrics(MetricGroup group, SingleInputGate gate) {
        InputGateMetrics metrics = new InputGateMetrics(gate);
        group.gauge("totalQueueLen", metrics.getTotalQueueLenGauge());
        group.gauge("minQueueLen", metrics.getMinQueueLenGauge());
        group.gauge("maxQueueLen", metrics.getMaxQueueLenGauge());
        group.gauge("avgQueueLen", metrics.getAvgQueueLenGauge());
    }
}

