/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class SingleLogicalSlot
implements LogicalSlot,
AllocatedSlot.Payload {
    private static final AtomicReferenceFieldUpdater<SingleLogicalSlot, LogicalSlot.Payload> PAYLOAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleLogicalSlot.class, LogicalSlot.Payload.class, "payload");
    private static final AtomicReferenceFieldUpdater<SingleLogicalSlot, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleLogicalSlot.class, State.class, "state");
    private final SlotRequestId slotRequestId;
    private final SlotContext slotContext;
    @Nullable
    private final SlotSharingGroupId slotSharingGroupId;
    private final Locality locality;
    private final SlotOwner slotOwner;
    private final CompletableFuture<Void> releaseFuture;
    private volatile State state;
    private volatile LogicalSlot.Payload payload;

    public SingleLogicalSlot(SlotRequestId slotRequestId, SlotContext slotContext, @Nullable SlotSharingGroupId slotSharingGroupId, Locality locality, SlotOwner slotOwner) {
        this.slotRequestId = (SlotRequestId)((Object)Preconditions.checkNotNull((Object)((Object)slotRequestId)));
        this.slotContext = (SlotContext)Preconditions.checkNotNull((Object)slotContext);
        this.slotSharingGroupId = slotSharingGroupId;
        this.locality = (Locality)((Object)Preconditions.checkNotNull((Object)((Object)locality)));
        this.slotOwner = (SlotOwner)Preconditions.checkNotNull((Object)slotOwner);
        this.releaseFuture = new CompletableFuture();
        this.state = State.ALIVE;
        this.payload = null;
    }

    @Override
    public TaskManagerLocation getTaskManagerLocation() {
        return this.slotContext.getTaskManagerLocation();
    }

    @Override
    public TaskManagerGateway getTaskManagerGateway() {
        return this.slotContext.getTaskManagerGateway();
    }

    @Override
    public Locality getLocality() {
        return this.locality;
    }

    @Override
    public boolean isAlive() {
        return this.state == State.ALIVE;
    }

    @Override
    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        return PAYLOAD_UPDATER.compareAndSet(this, null, payload);
    }

    @Override
    @Nullable
    public LogicalSlot.Payload getPayload() {
        return this.payload;
    }

    @Override
    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, State.ALIVE, State.RELEASING)) {
            CompletableFuture<?> payloadTerminalStateFuture = this.signalPayloadRelease(cause);
            this.returnSlotToOwner(payloadTerminalStateFuture);
        }
        return this.releaseFuture;
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.slotContext.getPhysicalSlotNumber();
    }

    @Override
    public AllocationID getAllocationId() {
        return this.slotContext.getAllocationId();
    }

    @Override
    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    @Override
    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    @Override
    public void release(Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, State.ALIVE, State.RELEASING)) {
            this.signalPayloadRelease(cause);
        }
        this.markReleased();
        this.releaseFuture.complete(null);
    }

    private CompletableFuture<?> signalPayloadRelease(Throwable cause) {
        this.tryAssignPayload(TERMINATED_PAYLOAD);
        this.payload.fail(cause);
        return this.payload.getTerminalStateFuture();
    }

    private void returnSlotToOwner(CompletableFuture<?> terminalStateFuture) {
        CompletionStage slotReturnFuture = ((CompletableFuture)terminalStateFuture.handle((ignored, throwable) -> {
            if (this.state == State.RELEASING) {
                return this.slotOwner.returnAllocatedSlot(this);
            }
            return CompletableFuture.completedFuture(true);
        })).thenCompose(Function.identity());
        ((CompletableFuture)slotReturnFuture).whenComplete((ignored, throwable) -> {
            this.markReleased();
            if (throwable != null) {
                this.releaseFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.releaseFuture.complete(null);
            }
        });
    }

    private void markReleased() {
        this.state = State.RELEASED;
    }

    static enum State {
        ALIVE,
        RELEASING,
        RELEASED;

    }
}

