/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractJobVertexHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.SubtaskIndexPathParameter;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public abstract class AbstractSubtaskHandler<R extends ResponseBody, M extends SubtaskMessageParameters>
extends AbstractJobVertexHandler<R, M> {
    protected AbstractSubtaskHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected R handleRequest(HandlerRequest<EmptyRequestBody, M> request, AccessExecutionJobVertex jobVertex) throws RestHandlerException {
        Integer subtaskIndex = (Integer)request.getPathParameter(SubtaskIndexPathParameter.class);
        AccessExecutionVertex[] executionVertices = jobVertex.getTaskVertices();
        if (subtaskIndex >= executionVertices.length || subtaskIndex < 0) {
            throw new RestHandlerException("Invalid subtask index for vertex " + (Object)((Object)jobVertex.getJobVertexId()), HttpResponseStatus.NOT_FOUND);
        }
        return this.handleRequest(request, executionVertices[subtaskIndex]);
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody, M> var1, AccessExecutionVertex var2) throws RestHandlerException;
}

