/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.versioning;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public enum RestAPIVersion {
    V0(0, false),
    V1(1, true);

    private final int versionNumber;
    private final boolean isDefaultVersion;

    private RestAPIVersion(int versionNumber, boolean isDefaultVersion) {
        this.versionNumber = versionNumber;
        this.isDefaultVersion = isDefaultVersion;
    }

    public String getURLVersionPrefix() {
        return this.name().toLowerCase();
    }

    public boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public static RestAPIVersion fromURLVersionPrefix(String prefix) {
        return RestAPIVersion.valueOf(prefix.toUpperCase());
    }

    public static RestAPIVersion getLatestVersion(Collection<RestAPIVersion> versions) {
        return Collections.max(versions, new RestAPIVersionComparator());
    }

    public static class RestAPIVersionComparator
    implements Comparator<RestAPIVersion> {
        @Override
        public int compare(RestAPIVersion o1, RestAPIVersion o2) {
            return Integer.compare(o1.versionNumber, o2.versionNumber);
        }
    }
}

