/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredPriorityQueueStateBackendMetaInfo<T>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final TypeSerializer<T> elementSerializer;

    public RegisteredPriorityQueueStateBackendMetaInfo(@Nonnull String name, @Nonnull TypeSerializer<T> elementSerializer) {
        super(name);
        this.elementSerializer = elementSerializer;
    }

    public RegisteredPriorityQueueStateBackendMetaInfo(StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), (TypeSerializer)Preconditions.checkNotNull(snapshot.restoreTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER)));
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, TypeSerializer<?>> serializerMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString(), this.elementSerializer.duplicate());
        Map<String, TypeSerializerSnapshot<?>> serializerSnapshotMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString(), this.elementSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE, Collections.emptyMap(), serializerSnapshotMap, serializerMap);
    }

    public RegisteredPriorityQueueStateBackendMetaInfo deepCopy() {
        return new RegisteredPriorityQueueStateBackendMetaInfo<T>(this.name, this.elementSerializer.duplicate());
    }
}

