/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Collection;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.ttl.AbstractTtlState;
import org.apache.flink.runtime.state.ttl.TtlAggregateFunction;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;

class TtlAggregatingState<K, N, IN, ACC, OUT>
extends AbstractTtlState<K, N, ACC, TtlValue<ACC>, InternalAggregatingState<K, N, IN, TtlValue<ACC>, OUT>>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    TtlAggregatingState(InternalAggregatingState<K, N, IN, TtlValue<ACC>, OUT> originalState, StateTtlConfig config, TtlTimeProvider timeProvider, TypeSerializer<ACC> valueSerializer, TtlAggregateFunction<IN, ACC, OUT> aggregateFunction) {
        super(originalState, config, timeProvider, valueSerializer);
        aggregateFunction.stateClear = () -> originalState.clear();
        aggregateFunction.updater = originalState::updateInternal;
    }

    public OUT get() throws Exception {
        return (OUT)((InternalAggregatingState)this.original).get();
    }

    public void add(IN value) throws Exception {
        ((InternalAggregatingState)this.original).add(value);
    }

    @Override
    public void clear() {
        ((InternalAggregatingState)this.original).clear();
    }

    @Override
    public ACC getInternal() throws Exception {
        return (ACC)this.getWithTtlCheckAndUpdate(((InternalAggregatingState)this.original)::getInternal, ((InternalAggregatingState)this.original)::updateInternal);
    }

    @Override
    public void updateInternal(ACC valueToStore) throws Exception {
        ((InternalAggregatingState)this.original).updateInternal(this.wrapWithTs(valueToStore));
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalAggregatingState)this.original).mergeNamespaces(target, sources);
    }
}

