/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotState;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.util.Preconditions;

public class TaskSlot {
    private final int index;
    private final ResourceProfile resourceProfile;
    private final Map<ExecutionAttemptID, Task> tasks;
    private TaskSlotState state;
    private JobID jobId;
    private AllocationID allocationId;

    TaskSlot(int index, ResourceProfile resourceProfile) {
        Preconditions.checkArgument((0 <= index ? 1 : 0) != 0, (Object)"The index must be greater than 0.");
        this.index = index;
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.tasks = new HashMap<ExecutionAttemptID, Task>(4);
        this.state = TaskSlotState.FREE;
        this.jobId = null;
        this.allocationId = null;
    }

    public int getIndex() {
        return this.index;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    TaskSlotState getState() {
        return this.state;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean isFree() {
        return TaskSlotState.FREE == this.state;
    }

    public boolean isActive(JobID activeJobId, AllocationID activeAllocationId) {
        Preconditions.checkNotNull((Object)activeJobId);
        Preconditions.checkNotNull((Object)((Object)activeAllocationId));
        return TaskSlotState.ACTIVE == this.state && activeJobId.equals((Object)this.jobId) && activeAllocationId.equals((Object)this.allocationId);
    }

    public boolean isAllocated(JobID jobIdToCheck, AllocationID allocationIDToCheck) {
        Preconditions.checkNotNull((Object)jobIdToCheck);
        Preconditions.checkNotNull((Object)((Object)allocationIDToCheck));
        return jobIdToCheck.equals((Object)this.jobId) && allocationIDToCheck.equals((Object)this.allocationId) && (TaskSlotState.ACTIVE == this.state || TaskSlotState.ALLOCATED == this.state);
    }

    public boolean isReleasing() {
        return TaskSlotState.RELEASING == this.state;
    }

    public Iterator<Task> getTasks() {
        return this.tasks.values().iterator();
    }

    public boolean add(Task task) {
        Preconditions.checkArgument((boolean)task.getJobID().equals((Object)this.jobId), (Object)"The task's job id does not match the job id for which the slot has been allocated.");
        Preconditions.checkArgument((boolean)task.getAllocationId().equals((Object)this.allocationId), (Object)"The task's allocation id does not match the allocation id for which the slot has been allocated.");
        Preconditions.checkState((TaskSlotState.ACTIVE == this.state ? 1 : 0) != 0, (Object)"The task slot is not in state active.");
        Task oldTask = this.tasks.put(task.getExecutionId(), task);
        if (oldTask != null) {
            this.tasks.put(task.getExecutionId(), oldTask);
            return false;
        }
        return true;
    }

    public Task remove(ExecutionAttemptID executionAttemptId) {
        return this.tasks.remove((Object)executionAttemptId);
    }

    public void clear() {
        this.tasks.clear();
    }

    public boolean allocate(JobID newJobId, AllocationID newAllocationId) {
        if (TaskSlotState.FREE == this.state) {
            Preconditions.checkState((this.allocationId == null ? 1 : 0) != 0);
            Preconditions.checkState((this.jobId == null ? 1 : 0) != 0);
            this.jobId = (JobID)Preconditions.checkNotNull((Object)newJobId);
            this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)newAllocationId)));
            this.state = TaskSlotState.ALLOCATED;
            return true;
        }
        if (TaskSlotState.ALLOCATED == this.state || TaskSlotState.ACTIVE == this.state) {
            Preconditions.checkNotNull((Object)newJobId);
            Preconditions.checkNotNull((Object)((Object)newAllocationId));
            return newJobId.equals((Object)this.jobId) && newAllocationId.equals((Object)this.allocationId);
        }
        return false;
    }

    public boolean markActive() {
        if (TaskSlotState.ALLOCATED == this.state || TaskSlotState.ACTIVE == this.state) {
            this.state = TaskSlotState.ACTIVE;
            return true;
        }
        return false;
    }

    public boolean markInactive() {
        if (TaskSlotState.ACTIVE == this.state || TaskSlotState.ALLOCATED == this.state) {
            this.state = TaskSlotState.ALLOCATED;
            return true;
        }
        return false;
    }

    public boolean markFree() {
        if (this.isEmpty()) {
            this.state = TaskSlotState.FREE;
            this.jobId = null;
            this.allocationId = null;
            return true;
        }
        return false;
    }

    public boolean markReleasing() {
        this.state = TaskSlotState.RELEASING;
        return true;
    }

    public SlotOffer generateSlotOffer() {
        Preconditions.checkState((TaskSlotState.ACTIVE == this.state || TaskSlotState.ALLOCATED == this.state ? 1 : 0) != 0, (Object)"The task slot is not in state active or allocated.");
        Preconditions.checkState((this.allocationId != null ? 1 : 0) != 0, (Object)"The task slot are not allocated");
        return new SlotOffer(this.allocationId, this.index, this.resourceProfile);
    }

    public String toString() {
        return "TaskSlot(index:" + this.index + ", state:" + (Object)((Object)this.state) + ", resource profile: " + this.resourceProfile + ", allocationId: " + (this.allocationId != null ? this.allocationId.toString() : "none") + ", jobId: " + (this.jobId != null ? this.jobId.toString() : "none") + ')';
    }
}

