/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.net.InetSocketAddress;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateMessage;
import org.apache.flink.runtime.query.KvStateRegistryListener;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.Preconditions;

public class ActorGatewayKvStateRegistryListener
implements KvStateRegistryListener {
    private ActorGateway jobManager;
    private InetSocketAddress kvStateServerAddress;

    public ActorGatewayKvStateRegistryListener(ActorGateway jobManager, InetSocketAddress kvStateServerAddress) {
        this.jobManager = (ActorGateway)Preconditions.checkNotNull((Object)jobManager, (String)"JobManager");
        this.kvStateServerAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)kvStateServerAddress, (String)"ServerAddress");
    }

    @Override
    public void notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId) {
        KvStateMessage.NotifyKvStateRegistered msg = new KvStateMessage.NotifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId, this.kvStateServerAddress);
        this.jobManager.tell(msg);
    }

    @Override
    public void notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
        KvStateMessage.NotifyKvStateUnregistered msg = new KvStateMessage.NotifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
        this.jobManager.tell(msg);
    }
}

