/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.InputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.OutputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.CoFeedbackTransformation;
import org.apache.flink.streaming.api.transformations.FeedbackTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.api.transformations.SelectTransformation;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.streaming.api.transformations.SplitTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamGraphGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraphGenerator.class);
    public static final int DEFAULT_LOWER_BOUND_MAX_PARALLELISM = 128;
    public static final ScheduleMode DEFAULT_SCHEDULE_MODE = ScheduleMode.EAGER;
    public static final TimeCharacteristic DEFAULT_TIME_CHARACTERISTIC = TimeCharacteristic.ProcessingTime;
    public static final String DEFAULT_JOB_NAME = "Flink Streaming Job";
    public static final long DEFAULT_NETWORK_BUFFER_TIMEOUT = 100L;
    public static final String DEFAULT_SLOT_SHARING_GROUP = "default";
    private final List<Transformation<?>> transformations;
    private final ExecutionConfig executionConfig;
    private final CheckpointConfig checkpointConfig;
    private SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
    private StateBackend stateBackend;
    private boolean chaining = true;
    private ScheduleMode scheduleMode = DEFAULT_SCHEDULE_MODE;
    private Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts;
    private TimeCharacteristic timeCharacteristic = DEFAULT_TIME_CHARACTERISTIC;
    private long defaultBufferTimeout = 100L;
    private String jobName = "Flink Streaming Job";
    private boolean blockingConnectionsBetweenChains = false;
    protected static Integer iterationIdCounter = 0;
    private StreamGraph streamGraph;
    private Map<Transformation<?>, Collection<Integer>> alreadyTransformed;

    public static int getNewIterationNodeId() {
        Integer n = iterationIdCounter;
        Integer n2 = iterationIdCounter = Integer.valueOf(iterationIdCounter - 1);
        return iterationIdCounter;
    }

    public StreamGraphGenerator(List<Transformation<?>> transformations, ExecutionConfig executionConfig, CheckpointConfig checkpointConfig) {
        this.transformations = (List)Preconditions.checkNotNull(transformations);
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.checkpointConfig = (CheckpointConfig)Preconditions.checkNotNull((Object)checkpointConfig);
    }

    public StreamGraphGenerator setStateBackend(StateBackend stateBackend) {
        this.stateBackend = stateBackend;
        return this;
    }

    public StreamGraphGenerator setChaining(boolean chaining) {
        this.chaining = chaining;
        return this;
    }

    public StreamGraphGenerator setScheduleMode(ScheduleMode scheduleMode) {
        this.scheduleMode = scheduleMode;
        return this;
    }

    public StreamGraphGenerator setUserArtifacts(Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts) {
        this.userArtifacts = userArtifacts;
        return this;
    }

    public StreamGraphGenerator setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        this.timeCharacteristic = timeCharacteristic;
        return this;
    }

    public StreamGraphGenerator setDefaultBufferTimeout(long defaultBufferTimeout) {
        this.defaultBufferTimeout = defaultBufferTimeout;
        return this;
    }

    public StreamGraphGenerator setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public StreamGraphGenerator setBlockingConnectionsBetweenChains(boolean blockingConnectionsBetweenChains) {
        this.blockingConnectionsBetweenChains = blockingConnectionsBetweenChains;
        return this;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings savepointRestoreSettings) {
        this.savepointRestoreSettings = savepointRestoreSettings;
    }

    public StreamGraph generate() {
        this.streamGraph = new StreamGraph(this.executionConfig, this.checkpointConfig, this.savepointRestoreSettings);
        this.streamGraph.setStateBackend(this.stateBackend);
        this.streamGraph.setChaining(this.chaining);
        this.streamGraph.setScheduleMode(this.scheduleMode);
        this.streamGraph.setUserArtifacts(this.userArtifacts);
        this.streamGraph.setTimeCharacteristic(this.timeCharacteristic);
        this.streamGraph.setJobName(this.jobName);
        this.streamGraph.setBlockingConnectionsBetweenChains(this.blockingConnectionsBetweenChains);
        this.alreadyTransformed = new HashMap();
        for (Transformation<?> transformation : this.transformations) {
            this.transform(transformation);
        }
        StreamGraph builtStreamGraph = this.streamGraph;
        this.alreadyTransformed.clear();
        this.alreadyTransformed = null;
        this.streamGraph = null;
        return builtStreamGraph;
    }

    private Collection<Integer> transform(Transformation<?> transform) {
        Collection<Integer> transformedIds;
        int globalMaxParallelismFromConfig;
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        LOG.debug("Transforming " + transform);
        if (transform.getMaxParallelism() <= 0 && (globalMaxParallelismFromConfig = this.executionConfig.getMaxParallelism()) > 0) {
            transform.setMaxParallelism(globalMaxParallelismFromConfig);
        }
        transform.getOutputType();
        if (transform instanceof OneInputTransformation) {
            transformedIds = this.transformOneInputTransform((OneInputTransformation)transform);
        } else if (transform instanceof TwoInputTransformation) {
            transformedIds = this.transformTwoInputTransform((TwoInputTransformation)transform);
        } else if (transform instanceof SourceTransformation) {
            transformedIds = this.transformSource((SourceTransformation)transform);
        } else if (transform instanceof SinkTransformation) {
            transformedIds = this.transformSink((SinkTransformation)transform);
        } else if (transform instanceof UnionTransformation) {
            transformedIds = this.transformUnion((UnionTransformation)transform);
        } else if (transform instanceof SplitTransformation) {
            transformedIds = this.transformSplit((SplitTransformation)transform);
        } else if (transform instanceof SelectTransformation) {
            transformedIds = this.transformSelect((SelectTransformation)transform);
        } else if (transform instanceof FeedbackTransformation) {
            transformedIds = this.transformFeedback((FeedbackTransformation)transform);
        } else if (transform instanceof CoFeedbackTransformation) {
            transformedIds = this.transformCoFeedback((CoFeedbackTransformation)transform);
        } else if (transform instanceof PartitionTransformation) {
            transformedIds = this.transformPartition((PartitionTransformation)transform);
        } else if (transform instanceof SideOutputTransformation) {
            transformedIds = this.transformSideOutput((SideOutputTransformation)transform);
        } else {
            throw new IllegalStateException("Unknown transformation: " + transform);
        }
        if (!this.alreadyTransformed.containsKey(transform)) {
            this.alreadyTransformed.put(transform, transformedIds);
        }
        if (transform.getBufferTimeout() >= 0L) {
            this.streamGraph.setBufferTimeout(transform.getId(), transform.getBufferTimeout());
        } else {
            this.streamGraph.setBufferTimeout(transform.getId(), this.defaultBufferTimeout);
        }
        if (transform.getUid() != null) {
            this.streamGraph.setTransformationUID(transform.getId(), transform.getUid());
        }
        if (transform.getUserProvidedNodeHash() != null) {
            this.streamGraph.setTransformationUserHash(transform.getId(), transform.getUserProvidedNodeHash());
        }
        if (!this.streamGraph.getExecutionConfig().hasAutoGeneratedUIDsEnabled() && transform instanceof PhysicalTransformation && transform.getUserProvidedNodeHash() == null && transform.getUid() == null) {
            throw new IllegalStateException("Auto generated UIDs have been disabled but no UID or hash has been assigned to operator " + transform.getName());
        }
        if (transform.getMinResources() != null && transform.getPreferredResources() != null) {
            this.streamGraph.setResources(transform.getId(), transform.getMinResources(), transform.getPreferredResources());
        }
        this.streamGraph.setManagedMemoryWeight(transform.getId(), transform.getManagedMemoryWeight());
        return transformedIds;
    }

    private <T> Collection<Integer> transformUnion(UnionTransformation<T> union) {
        List<Transformation<T>> inputs = union.getInputs();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        for (Transformation<T> input : inputs) {
            resultIds.addAll(this.transform(input));
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformPartition(PartitionTransformation<T> partition) {
        Transformation<T> input = partition.getInput();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        Collection<Integer> transformedIds = this.transform(input);
        for (Integer transformedId : transformedIds) {
            int virtualId = Transformation.getNewNodeId();
            this.streamGraph.addVirtualPartitionNode(transformedId, virtualId, partition.getPartitioner(), partition.getShuffleMode());
            resultIds.add(virtualId);
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformSplit(SplitTransformation<T> split) {
        Transformation<T> input = split.getInput();
        Collection<Integer> resultIds = this.transform(input);
        this.validateSplitTransformation(input);
        if (this.alreadyTransformed.containsKey(split)) {
            return this.alreadyTransformed.get(split);
        }
        for (int inputId : resultIds) {
            this.streamGraph.addOutputSelector(inputId, split.getOutputSelector());
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformSelect(SelectTransformation<T> select) {
        Transformation<T> input = select.getInput();
        Collection<Integer> resultIds = this.transform(input);
        if (this.alreadyTransformed.containsKey(select)) {
            return this.alreadyTransformed.get(select);
        }
        ArrayList<Integer> virtualResultIds = new ArrayList<Integer>();
        for (int inputId : resultIds) {
            int virtualId = Transformation.getNewNodeId();
            this.streamGraph.addVirtualSelectNode(inputId, virtualId, select.getSelectedNames());
            virtualResultIds.add(virtualId);
        }
        return virtualResultIds;
    }

    private <T> Collection<Integer> transformSideOutput(SideOutputTransformation<T> sideOutput) {
        Transformation<?> input = sideOutput.getInput();
        Collection<Integer> resultIds = this.transform(input);
        if (this.alreadyTransformed.containsKey(sideOutput)) {
            return this.alreadyTransformed.get(sideOutput);
        }
        ArrayList<Integer> virtualResultIds = new ArrayList<Integer>();
        for (int inputId : resultIds) {
            int virtualId = Transformation.getNewNodeId();
            this.streamGraph.addVirtualSideOutputNode(inputId, virtualId, sideOutput.getOutputTag());
            virtualResultIds.add(virtualId);
        }
        return virtualResultIds;
    }

    private <T> Collection<Integer> transformFeedback(FeedbackTransformation<T> iterate) {
        if (iterate.getFeedbackEdges().size() <= 0) {
            throw new IllegalStateException("Iteration " + iterate + " does not have any feedback edges.");
        }
        Transformation<T> input = iterate.getInput();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        Collection<Integer> inputIds = this.transform(input);
        resultIds.addAll(inputIds);
        if (this.alreadyTransformed.containsKey(iterate)) {
            return this.alreadyTransformed.get(iterate);
        }
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(iterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), iterate.getWaitTime(), iterate.getParallelism(), iterate.getMaxParallelism(), iterate.getMinResources(), iterate.getPreferredResources());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, iterate.getOutputType().createSerializer(this.executionConfig));
        this.streamGraph.setSerializers(itSink.getId(), iterate.getOutputType().createSerializer(this.executionConfig), null, null);
        resultIds.add(itSource.getId());
        this.alreadyTransformed.put(iterate, resultIds);
        ArrayList<Integer> allFeedbackIds = new ArrayList<Integer>();
        for (Transformation<T> feedbackEdge : iterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            allFeedbackIds.addAll(feedbackIds);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        String slotSharingGroup = this.determineSlotSharingGroup(null, allFeedbackIds);
        if (slotSharingGroup == null) {
            slotSharingGroup = "SlotSharingGroup-" + iterate.getId();
        }
        itSink.setSlotSharingGroup(slotSharingGroup);
        itSource.setSlotSharingGroup(slotSharingGroup);
        return resultIds;
    }

    private <F> Collection<Integer> transformCoFeedback(CoFeedbackTransformation<F> coIterate) {
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(coIterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), coIterate.getWaitTime(), coIterate.getParallelism(), coIterate.getMaxParallelism(), coIterate.getMinResources(), coIterate.getPreferredResources());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, coIterate.getOutputType().createSerializer(this.executionConfig));
        this.streamGraph.setSerializers(itSink.getId(), coIterate.getOutputType().createSerializer(this.executionConfig), null, null);
        Set<Integer> resultIds = Collections.singleton(itSource.getId());
        this.alreadyTransformed.put(coIterate, resultIds);
        ArrayList<Integer> allFeedbackIds = new ArrayList<Integer>();
        for (Transformation<F> feedbackEdge : coIterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            allFeedbackIds.addAll(feedbackIds);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        String slotSharingGroup = this.determineSlotSharingGroup(null, allFeedbackIds);
        itSink.setSlotSharingGroup(slotSharingGroup);
        itSource.setSlotSharingGroup(slotSharingGroup);
        return Collections.singleton(itSource.getId());
    }

    private <T> Collection<Integer> transformSource(SourceTransformation<T> source) {
        String slotSharingGroup = this.determineSlotSharingGroup(source.getSlotSharingGroup(), Collections.emptyList());
        this.streamGraph.addSource(source.getId(), slotSharingGroup, source.getCoLocationGroupKey(), source.getOperatorFactory(), null, source.getOutputType(), "Source: " + source.getName());
        if (source.getOperatorFactory() instanceof InputFormatOperatorFactory) {
            this.streamGraph.setInputFormat(source.getId(), ((InputFormatOperatorFactory)source.getOperatorFactory()).getInputFormat());
        }
        int parallelism = source.getParallelism() != -1 ? source.getParallelism() : this.executionConfig.getParallelism();
        this.streamGraph.setParallelism(source.getId(), parallelism);
        this.streamGraph.setMaxParallelism(source.getId(), source.getMaxParallelism());
        return Collections.singleton(source.getId());
    }

    private <T> Collection<Integer> transformSink(SinkTransformation<T> sink) {
        Collection<Integer> inputIds = this.transform(sink.getInput());
        String slotSharingGroup = this.determineSlotSharingGroup(sink.getSlotSharingGroup(), inputIds);
        this.streamGraph.addSink(sink.getId(), slotSharingGroup, sink.getCoLocationGroupKey(), sink.getOperatorFactory(), sink.getInput().getOutputType(), null, "Sink: " + sink.getName());
        StreamOperatorFactory<Object> operatorFactory = sink.getOperatorFactory();
        if (operatorFactory instanceof OutputFormatOperatorFactory) {
            this.streamGraph.setOutputFormat(sink.getId(), ((OutputFormatOperatorFactory)operatorFactory).getOutputFormat());
        }
        int parallelism = sink.getParallelism() != -1 ? sink.getParallelism() : this.executionConfig.getParallelism();
        this.streamGraph.setParallelism(sink.getId(), parallelism);
        this.streamGraph.setMaxParallelism(sink.getId(), sink.getMaxParallelism());
        for (Integer inputId : inputIds) {
            this.streamGraph.addEdge(inputId, sink.getId(), 0);
        }
        if (sink.getStateKeySelector() != null) {
            TypeSerializer keySerializer = sink.getStateKeyType().createSerializer(this.executionConfig);
            this.streamGraph.setOneInputStateKey(sink.getId(), sink.getStateKeySelector(), keySerializer);
        }
        return Collections.emptyList();
    }

    private <IN, OUT> Collection<Integer> transformOneInputTransform(OneInputTransformation<IN, OUT> transform) {
        Collection<Integer> inputIds = this.transform(transform.getInput());
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        String slotSharingGroup = this.determineSlotSharingGroup(transform.getSlotSharingGroup(), inputIds);
        this.streamGraph.addOperator(transform.getId(), slotSharingGroup, transform.getCoLocationGroupKey(), transform.getOperatorFactory(), transform.getInputType(), transform.getOutputType(), transform.getName());
        if (transform.getStateKeySelector() != null) {
            TypeSerializer keySerializer = transform.getStateKeyType().createSerializer(this.executionConfig);
            this.streamGraph.setOneInputStateKey(transform.getId(), transform.getStateKeySelector(), keySerializer);
        }
        int parallelism = transform.getParallelism() != -1 ? transform.getParallelism() : this.executionConfig.getParallelism();
        this.streamGraph.setParallelism(transform.getId(), parallelism);
        this.streamGraph.setMaxParallelism(transform.getId(), transform.getMaxParallelism());
        for (Integer inputId : inputIds) {
            this.streamGraph.addEdge(inputId, transform.getId(), 0);
        }
        return Collections.singleton(transform.getId());
    }

    private <IN1, IN2, OUT> Collection<Integer> transformTwoInputTransform(TwoInputTransformation<IN1, IN2, OUT> transform) {
        Collection<Integer> inputIds1 = this.transform(transform.getInput1());
        Collection<Integer> inputIds2 = this.transform(transform.getInput2());
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        ArrayList<Integer> allInputIds = new ArrayList<Integer>();
        allInputIds.addAll(inputIds1);
        allInputIds.addAll(inputIds2);
        String slotSharingGroup = this.determineSlotSharingGroup(transform.getSlotSharingGroup(), allInputIds);
        this.streamGraph.addCoOperator(transform.getId(), slotSharingGroup, transform.getCoLocationGroupKey(), transform.getOperatorFactory(), transform.getInputType1(), transform.getInputType2(), transform.getOutputType(), transform.getName());
        if (transform.getStateKeySelector1() != null || transform.getStateKeySelector2() != null) {
            TypeSerializer keySerializer = transform.getStateKeyType().createSerializer(this.executionConfig);
            this.streamGraph.setTwoInputStateKey(transform.getId(), transform.getStateKeySelector1(), transform.getStateKeySelector2(), keySerializer);
        }
        int parallelism = transform.getParallelism() != -1 ? transform.getParallelism() : this.executionConfig.getParallelism();
        this.streamGraph.setParallelism(transform.getId(), parallelism);
        this.streamGraph.setMaxParallelism(transform.getId(), transform.getMaxParallelism());
        for (Integer inputId : inputIds1) {
            this.streamGraph.addEdge(inputId, transform.getId(), 1);
        }
        for (Integer inputId : inputIds2) {
            this.streamGraph.addEdge(inputId, transform.getId(), 2);
        }
        return Collections.singleton(transform.getId());
    }

    private String determineSlotSharingGroup(String specifiedGroup, Collection<Integer> inputIds) {
        if (specifiedGroup != null) {
            return specifiedGroup;
        }
        String inputGroup = null;
        for (int id : inputIds) {
            String inputGroupCandidate = this.streamGraph.getSlotSharingGroup(id);
            if (inputGroup == null) {
                inputGroup = inputGroupCandidate;
                continue;
            }
            if (inputGroup.equals(inputGroupCandidate)) continue;
            return DEFAULT_SLOT_SHARING_GROUP;
        }
        return inputGroup == null ? DEFAULT_SLOT_SHARING_GROUP : inputGroup;
    }

    private <T> void validateSplitTransformation(Transformation<T> input) {
        if (input instanceof SelectTransformation || input instanceof SplitTransformation) {
            throw new IllegalStateException("Consecutive multiple splits are not supported. Splits are deprecated. Please use side-outputs.");
        }
        if (input instanceof SideOutputTransformation) {
            throw new IllegalStateException("Split after side-outputs are not supported. Splits are deprecated. Please use side-outputs.");
        }
        if (input instanceof UnionTransformation) {
            for (Transformation transformation : ((UnionTransformation)input).getInputs()) {
                this.validateSplitTransformation(transformation);
            }
        } else if (input instanceof PartitionTransformation) {
            this.validateSplitTransformation(((PartitionTransformation)input).getInput());
        } else {
            return;
        }
    }
}

