/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;

@Internal
public class TwoInputSelectionHandler {
    @Nullable
    private final InputSelectable inputSelector;
    private InputSelection inputSelection;
    private int availableInputsMask;

    public TwoInputSelectionHandler(@Nullable InputSelectable inputSelectable) {
        this.inputSelector = inputSelectable;
        this.availableInputsMask = (int)new InputSelection.Builder().select(1).select(2).build().getInputMask();
    }

    void nextSelection() {
        this.inputSelection = this.inputSelector == null ? InputSelection.ALL : this.inputSelector.nextSelection();
    }

    int selectNextInputIndex(int lastReadInputIndex) {
        return this.inputSelection.fairSelectNextIndexOutOf2(this.availableInputsMask, lastReadInputIndex);
    }

    boolean shouldSetAvailableForAnotherInput() {
        return this.availableInputsMask < 3 && this.inputSelection.isALLMaskOf2();
    }

    void setAvailableInput(int inputIndex) {
        this.availableInputsMask |= 1 << inputIndex;
    }

    void setUnavailableInput(int inputIndex) {
        this.availableInputsMask &= ~(1 << inputIndex);
    }

    boolean areAllInputsSelected() {
        return this.inputSelection.isALLMaskOf2();
    }

    boolean isFirstInputSelected() {
        return this.inputSelection.isInputSelected(1);
    }

    boolean isSecondInputSelected() {
        return this.inputSelection.isInputSelected(2);
    }
}

