/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.datagen;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;

@Experimental
public class DataGeneratorSource<T>
extends RichParallelSourceFunction<T>
implements CheckpointedFunction {
    private static final long serialVersionUID = 1L;
    private final DataGenerator<T> generator;
    private final long rowsPerSecond;
    volatile transient boolean isRunning;

    public DataGeneratorSource(DataGenerator<T> generator) {
        this(generator, Long.MAX_VALUE);
    }

    public DataGeneratorSource(DataGenerator<T> generator, long rowsPerSecond) {
        this.generator = generator;
        this.rowsPerSecond = rowsPerSecond;
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        this.generator.open("DataGenerator", context, this.getRuntimeContext());
        this.isRunning = true;
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.generator.snapshotState(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        double taskRowsPerSecond = (double)this.rowsPerSecond / (double)this.getRuntimeContext().getNumberOfParallelSubtasks();
        long nextReadTime = System.currentTimeMillis();
        while (this.isRunning) {
            int i = 0;
            while ((double)i < taskRowsPerSecond) {
                if (this.isRunning && this.generator.hasNext()) {
                    Object object = ctx.getCheckpointLock();
                    synchronized (object) {
                        ctx.collect(this.generator.next());
                    }
                } else {
                    return;
                }
                ++i;
            }
            long toWaitMs = (nextReadTime += 1000L) - System.currentTimeMillis();
            while (toWaitMs > 0L) {
                Thread.sleep(toWaitMs);
                toWaitMs = nextReadTime - System.currentTimeMillis();
            }
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }
}

