/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;

@Public
public class DataStreamSource<T>
extends SingleOutputStreamOperator<T> {
    boolean isParallel;

    public DataStreamSource(StreamExecutionEnvironment environment, TypeInformation<T> outTypeInfo, StreamSource<T, ?> operator, boolean isParallel, String sourceName) {
        super(environment, new LegacySourceTransformation<T>(sourceName, operator, outTypeInfo, environment.getParallelism()));
        this.isParallel = isParallel;
        if (!isParallel) {
            this.setParallelism(1);
        }
    }

    public DataStreamSource(SingleOutputStreamOperator<T> operator) {
        super(operator.environment, operator.getTransformation());
        this.isParallel = true;
    }

    public DataStreamSource(StreamExecutionEnvironment environment, Source<T, ?, ?> source, WatermarkStrategy<T> timestampsAndWatermarks, TypeInformation<T> outTypeInfo, String sourceName) {
        super(environment, new SourceTransformation<T>(sourceName, new SourceOperatorFactory<T>(source, timestampsAndWatermarks), outTypeInfo, environment.getParallelism()));
    }

    @Override
    public DataStreamSource<T> setParallelism(int parallelism) {
        OperatorValidationUtils.validateParallelism((int)parallelism, (boolean)this.isParallel);
        super.setParallelism(parallelism);
        return this;
    }
}

