/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;

public class CollectCoordinationResponse<T>
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    private static final TypeSerializer<String> versionSerializer = StringSerializer.INSTANCE;
    private static final TypeSerializer<Long> offsetSerializer = LongSerializer.INSTANCE;
    private final String version;
    private final long lastCheckpointedOffset;
    private final byte[] resultBytes;

    public CollectCoordinationResponse(String version, long lastCheckpointedOffset, List<T> results, TypeSerializer<T> elementSerializer) throws IOException {
        this.version = version;
        this.lastCheckpointedOffset = lastCheckpointedOffset;
        ListSerializer listSerializer = new ListSerializer(elementSerializer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
        listSerializer.serialize(results, (DataOutputView)wrapper);
        this.resultBytes = baos.toByteArray();
    }

    public CollectCoordinationResponse(DataInputView inView) throws IOException {
        this.version = (String)versionSerializer.deserialize(inView);
        this.lastCheckpointedOffset = (Long)offsetSerializer.deserialize(inView);
        int size = inView.readInt();
        this.resultBytes = new byte[size];
        inView.readFully(this.resultBytes);
    }

    public String getVersion() {
        return this.version;
    }

    public long getLastCheckpointedOffset() {
        return this.lastCheckpointedOffset;
    }

    public List<T> getResults(TypeSerializer<T> elementSerializer) throws IOException {
        ListSerializer listSerializer = new ListSerializer(elementSerializer);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.resultBytes);
        DataInputViewStreamWrapper wrapper = new DataInputViewStreamWrapper((InputStream)bais);
        return listSerializer.deserialize((DataInputView)wrapper);
    }

    public void serialize(DataOutputView outView) throws IOException {
        versionSerializer.serialize((Object)this.version, outView);
        offsetSerializer.serialize((Object)this.lastCheckpointedOffset, outView);
        outView.writeInt(this.resultBytes.length);
        outView.write(this.resultBytes);
    }
}

