/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.util.Preconditions;

@Internal
public final class WatermarkToDataOutput
implements WatermarkOutput {
    private final PushingAsyncDataInput.DataOutput<?> output;
    private long maxWatermarkSoFar;
    private boolean isIdle;

    public WatermarkToDataOutput(PushingAsyncDataInput.DataOutput<?> output) {
        this.output = (PushingAsyncDataInput.DataOutput)Preconditions.checkNotNull(output);
        this.maxWatermarkSoFar = Long.MIN_VALUE;
    }

    public void emitWatermark(org.apache.flink.api.common.eventtime.Watermark watermark) {
        long newWatermark = watermark.getTimestamp();
        if (newWatermark <= this.maxWatermarkSoFar) {
            return;
        }
        this.maxWatermarkSoFar = newWatermark;
        try {
            if (this.isIdle) {
                this.output.emitStreamStatus(StreamStatus.ACTIVE);
                this.isIdle = false;
            }
            this.output.emitWatermark(new Watermark(newWatermark));
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    public void markIdle() {
        if (this.isIdle) {
            return;
        }
        try {
            this.output.emitStreamStatus(StreamStatus.IDLE);
            this.isIdle = true;
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }
}

