/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

public abstract class CheckpointBarrierHandler
implements Closeable {
    private final AbstractInvokable toNotifyOnCheckpoint;
    private long latestCheckpointStartDelayNanos;

    public CheckpointBarrierHandler(AbstractInvokable toNotifyOnCheckpoint) {
        this.toNotifyOnCheckpoint = (AbstractInvokable)Preconditions.checkNotNull((Object)toNotifyOnCheckpoint);
    }

    public void releaseBlocksAndResetBarriers() throws IOException {
    }

    public boolean isBlocked(InputChannelInfo channelInfo) {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public abstract void processBarrier(CheckpointBarrier var1, InputChannelInfo var2) throws Exception;

    public abstract void processCancellationBarrier(CancelCheckpointMarker var1) throws Exception;

    public abstract void processEndOfPartition() throws Exception;

    public abstract long getLatestCheckpointId();

    public long getAlignmentDurationNanos() {
        return 0L;
    }

    public long getCheckpointStartDelayNanos() {
        return this.latestCheckpointStartDelayNanos;
    }

    public Optional<BufferReceivedListener> getBufferReceivedListener() {
        return Optional.empty();
    }

    public boolean hasInflightData(long checkpointId, InputChannelInfo channelInfo) {
        return false;
    }

    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        return CompletableFuture.completedFuture(null);
    }

    protected void notifyCheckpoint(CheckpointBarrier checkpointBarrier, long alignmentDurationNanos) throws IOException {
        CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointBarrier.getId(), checkpointBarrier.getTimestamp());
        CheckpointMetrics checkpointMetrics = new CheckpointMetrics().setAlignmentDurationNanos(alignmentDurationNanos).setCheckpointStartDelayNanos(this.latestCheckpointStartDelayNanos);
        this.toNotifyOnCheckpoint.triggerCheckpointOnBarrier(checkpointMetaData, checkpointBarrier.getCheckpointOptions(), checkpointMetrics);
    }

    protected void notifyAbortOnCancellationBarrier(long checkpointId) throws IOException {
        this.notifyAbort(checkpointId, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER));
    }

    protected void notifyAbort(long checkpointId, CheckpointException cause) throws IOException {
        this.toNotifyOnCheckpoint.abortCheckpointOnBarrier(checkpointId, (Throwable)cause);
    }

    protected void markCheckpointStart(long checkpointCreationTimestamp) {
        this.latestCheckpointStartDelayNanos = 1000000L * Math.max(0L, System.currentTimeMillis() - checkpointCreationTimestamp);
    }

    protected <E extends Exception> void executeInTaskThread(ThrowingRunnable<E> runnable, String descriptionFormat, Object ... descriptionArgs) throws E {
        this.toNotifyOnCheckpoint.executeInTaskThread(runnable, descriptionFormat, descriptionArgs);
    }

    protected abstract boolean isCheckpointPending();

    protected void abortPendingCheckpoint(long checkpointId, CheckpointException exception) throws IOException {
    }
}

