/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CheckpointBarrierTracker
extends CheckpointBarrierHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointBarrierTracker.class);
    private static final int MAX_CHECKPOINTS_TO_TRACK = 50;
    private final int totalNumberOfInputChannels;
    private final ArrayDeque<CheckpointBarrierCount> pendingCheckpoints;
    private long latestPendingCheckpointID = -1L;

    public CheckpointBarrierTracker(int totalNumberOfInputChannels, AbstractInvokable toNotifyOnCheckpoint) {
        super(toNotifyOnCheckpoint);
        this.totalNumberOfInputChannels = totalNumberOfInputChannels;
        this.pendingCheckpoints = new ArrayDeque();
    }

    @Override
    public void processBarrier(CheckpointBarrier receivedBarrier, InputChannelInfo channelInfo) throws Exception {
        long barrierId = receivedBarrier.getId();
        if (this.totalNumberOfInputChannels == 1) {
            this.notifyCheckpoint(receivedBarrier, 0L);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received barrier for checkpoint {} from channel {}", (Object)barrierId, (Object)channelInfo);
        }
        CheckpointBarrierCount barrierCount = null;
        int pos = 0;
        for (CheckpointBarrierCount next : this.pendingCheckpoints) {
            if (next.checkpointId == barrierId) {
                barrierCount = next;
                break;
            }
            ++pos;
        }
        if (barrierCount != null) {
            int numBarriersNew = barrierCount.incrementBarrierCount();
            if (numBarriersNew == this.totalNumberOfInputChannels) {
                for (int i = 0; i <= pos; ++i) {
                    this.pendingCheckpoints.pollFirst();
                }
                if (!barrierCount.isAborted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received all barriers for checkpoint {}", (Object)barrierId);
                    }
                    this.notifyCheckpoint(receivedBarrier, 0L);
                }
            }
        } else if (barrierId > this.latestPendingCheckpointID) {
            this.markCheckpointStart(receivedBarrier.getTimestamp());
            this.latestPendingCheckpointID = barrierId;
            this.pendingCheckpoints.addLast(new CheckpointBarrierCount(barrierId));
            if (this.pendingCheckpoints.size() > 50) {
                this.pendingCheckpoints.pollFirst();
            }
        }
    }

    @Override
    public void processCancellationBarrier(CancelCheckpointMarker cancelBarrier) throws Exception {
        CheckpointBarrierCount cbc;
        long checkpointId = cancelBarrier.getCheckpointId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received cancellation barrier for checkpoint {}", (Object)checkpointId);
        }
        if (this.totalNumberOfInputChannels == 1) {
            this.notifyAbortOnCancellationBarrier(checkpointId);
            return;
        }
        while ((cbc = this.pendingCheckpoints.peekFirst()) != null && cbc.checkpointId() < checkpointId) {
            this.pendingCheckpoints.removeFirst();
            if (!cbc.markAborted()) continue;
            this.notifyAbortOnCancellationBarrier(cbc.checkpointId());
        }
        if (cbc != null && cbc.checkpointId() == checkpointId) {
            if (cbc.markAborted()) {
                this.notifyAbortOnCancellationBarrier(checkpointId);
            }
            if (cbc.incrementBarrierCount() == this.totalNumberOfInputChannels) {
                this.pendingCheckpoints.removeFirst();
            }
        } else if (checkpointId > this.latestPendingCheckpointID) {
            this.notifyAbortOnCancellationBarrier(checkpointId);
            this.latestPendingCheckpointID = checkpointId;
            CheckpointBarrierCount abortedMarker = new CheckpointBarrierCount(checkpointId);
            abortedMarker.markAborted();
            this.pendingCheckpoints.addFirst(abortedMarker);
        }
    }

    @Override
    public void processEndOfPartition() throws Exception {
        while (!this.pendingCheckpoints.isEmpty()) {
            CheckpointBarrierCount barrierCount = this.pendingCheckpoints.removeFirst();
            if (!barrierCount.markAborted()) continue;
            this.notifyAbort(barrierCount.checkpointId(), new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_INPUT_END_OF_STREAM));
        }
    }

    @Override
    public long getLatestCheckpointId() {
        return this.pendingCheckpoints.isEmpty() ? -1L : this.pendingCheckpoints.peekLast().checkpointId();
    }

    @Override
    public boolean isCheckpointPending() {
        return !this.pendingCheckpoints.isEmpty();
    }

    private static final class CheckpointBarrierCount {
        private final long checkpointId;
        private int barrierCount;
        private boolean aborted;

        CheckpointBarrierCount(long checkpointId) {
            this.checkpointId = checkpointId;
            this.barrierCount = 1;
        }

        public long checkpointId() {
            return this.checkpointId;
        }

        public int incrementBarrierCount() {
            return ++this.barrierCount;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public boolean markAborted() {
            boolean firstAbort = !this.aborted;
            this.aborted = true;
            return firstAbort;
        }

        public String toString() {
            return this.isAborted() ? String.format("checkpointID=%d - ABORTED", this.checkpointId) : String.format("checkpointID=%d, count=%d", this.checkpointId, this.barrierCount);
        }
    }
}

