/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusProvider;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.tasks.WatermarkGaugeExposingOutput;
import org.apache.flink.util.OutputTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChainingOutput<T>
implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingOutput.class);
    protected final Input<T> input;
    protected final Counter numRecordsIn;
    protected final WatermarkGauge watermarkGauge = new WatermarkGauge();
    protected final StreamStatusProvider streamStatusProvider;
    @Nullable
    protected final OutputTag<T> outputTag;

    public ChainingOutput(OneInputStreamOperator<T, ?> operator, StreamStatusProvider streamStatusProvider, @Nullable OutputTag<T> outputTag) {
        this(operator, (OperatorMetricGroup)operator.getMetricGroup(), streamStatusProvider, outputTag);
    }

    public ChainingOutput(Input<T> input, OperatorMetricGroup operatorMetricGroup, StreamStatusProvider streamStatusProvider, @Nullable OutputTag<T> outputTag) {
        Counter tmpNumRecordsIn;
        this.input = input;
        try {
            OperatorIOMetricGroup ioMetricGroup = operatorMetricGroup.getIOMetricGroup();
            tmpNumRecordsIn = ioMetricGroup.getNumRecordsInCounter();
        }
        catch (Exception e) {
            LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
            tmpNumRecordsIn = new SimpleCounter();
        }
        this.numRecordsIn = tmpNumRecordsIn;
        this.streamStatusProvider = streamStatusProvider;
        this.outputTag = outputTag;
    }

    public void collect(StreamRecord<T> record) {
        if (this.outputTag != null) {
            return;
        }
        this.pushToOperator(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        if (OutputTag.isResponsibleFor(this.outputTag, outputTag)) {
            this.pushToOperator(record);
        }
    }

    protected <X> void pushToOperator(StreamRecord<X> record) {
        try {
            StreamRecord<X> castRecord = record;
            this.numRecordsIn.inc();
            this.input.setKeyContextElement(castRecord);
            this.input.processElement(castRecord);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        try {
            this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
            if (this.streamStatusProvider.getStreamStatus().isActive()) {
                this.input.processWatermark(mark);
            }
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        try {
            this.input.processLatencyMarker(latencyMarker);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Gauge<Long> getWatermarkGauge() {
        return this.watermarkGauge;
    }
}

