/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
final class BulkPartWriter<IN, BucketID>
extends PartFileWriter<IN, BucketID> {
    private final BulkWriter<IN> writer;

    private BulkPartWriter(BucketID bucketId, RecoverableFsDataOutputStream currentPartStream, BulkWriter<IN> writer, long creationTime) {
        super(bucketId, currentPartStream, creationTime);
        this.writer = (BulkWriter)Preconditions.checkNotNull(writer);
    }

    @Override
    void write(IN element, long currentTime) throws IOException {
        this.writer.addElement(element);
        this.markWrite(currentTime);
    }

    @Override
    RecoverableWriter.ResumeRecoverable persist() {
        throw new UnsupportedOperationException("Bulk Part Writers do not support \"pause and resume\" operations.");
    }

    @Override
    RecoverableWriter.CommitRecoverable closeForCommit() throws IOException {
        this.writer.flush();
        this.writer.finish();
        return super.closeForCommit();
    }

    static class Factory<IN, BucketID>
    implements PartFileWriter.PartFileFactory<IN, BucketID> {
        private final BulkWriter.Factory<IN> writerFactory;

        Factory(BulkWriter.Factory<IN> writerFactory) {
            this.writerFactory = writerFactory;
        }

        @Override
        public PartFileWriter<IN, BucketID> resumeFrom(BucketID bucketId, RecoverableWriter fileSystemWriter, RecoverableWriter.ResumeRecoverable resumable, long creationTime) throws IOException {
            Preconditions.checkNotNull((Object)fileSystemWriter);
            Preconditions.checkNotNull((Object)resumable);
            RecoverableFsDataOutputStream stream = fileSystemWriter.recover(resumable);
            BulkWriter writer = this.writerFactory.create((FSDataOutputStream)stream);
            return new BulkPartWriter(bucketId, stream, writer, creationTime);
        }

        @Override
        public PartFileWriter<IN, BucketID> openNew(BucketID bucketId, RecoverableWriter fileSystemWriter, Path path, long creationTime) throws IOException {
            Preconditions.checkNotNull((Object)fileSystemWriter);
            Preconditions.checkNotNull((Object)path);
            RecoverableFsDataOutputStream stream = fileSystemWriter.open(path);
            BulkWriter writer = this.writerFactory.create((FSDataOutputStream)stream);
            return new BulkPartWriter(bucketId, stream, writer, creationTime);
        }
    }
}

