/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileInfo;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
abstract class PartFileWriter<IN, BucketID>
implements PartFileInfo<BucketID> {
    private final BucketID bucketId;
    private final long creationTime;
    protected final RecoverableFsDataOutputStream currentPartStream;
    private long lastUpdateTime;

    protected PartFileWriter(BucketID bucketId, RecoverableFsDataOutputStream currentPartStream, long creationTime) {
        Preconditions.checkArgument((creationTime >= 0L ? 1 : 0) != 0);
        this.bucketId = Preconditions.checkNotNull(bucketId);
        this.currentPartStream = (RecoverableFsDataOutputStream)Preconditions.checkNotNull((Object)currentPartStream);
        this.creationTime = creationTime;
        this.lastUpdateTime = creationTime;
    }

    abstract void write(IN var1, long var2) throws IOException;

    RecoverableWriter.ResumeRecoverable persist() throws IOException {
        return this.currentPartStream.persist();
    }

    RecoverableWriter.CommitRecoverable closeForCommit() throws IOException {
        return this.currentPartStream.closeForCommit().getRecoverable();
    }

    void dispose() {
        IOUtils.closeQuietly((AutoCloseable)this.currentPartStream);
    }

    void markWrite(long now) {
        this.lastUpdateTime = now;
    }

    @Override
    public BucketID getBucketId() {
        return this.bucketId;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getSize() throws IOException {
        return this.currentPartStream.getPos();
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    static interface PartFileFactory<IN, BucketID> {
        public PartFileWriter<IN, BucketID> resumeFrom(BucketID var1, RecoverableWriter var2, RecoverableWriter.ResumeRecoverable var3, long var4) throws IOException;

        public PartFileWriter<IN, BucketID> openNew(BucketID var1, RecoverableWriter var2, Path var3, long var4) throws IOException;
    }
}

