/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;

@Internal
public class TimestampedCollector<T>
implements Collector<T> {
    private final Output<StreamRecord<T>> output;
    private final StreamRecord<T> reuse;

    public TimestampedCollector(Output<StreamRecord<T>> output) {
        this.output = output;
        this.reuse = new StreamRecord<Object>(null);
    }

    public void collect(T record) {
        this.output.collect(this.reuse.replace(record));
    }

    public void setTimestamp(StreamRecord<?> timestampBase) {
        if (timestampBase.hasTimestamp()) {
            this.reuse.setTimestamp(timestampBase.getTimestamp());
        } else {
            this.reuse.eraseTimestamp();
        }
    }

    public void setAbsoluteTimestamp(long timestamp) {
        this.reuse.setTimestamp(timestamp);
    }

    public void eraseTimestamp() {
        this.reuse.eraseTimestamp();
    }

    public void close() {
        this.output.close();
    }
}

