/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.utils;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeLookup;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;

@Internal
public final class UnknownCallContext
implements CallContext {
    private static final DataType NULL = DataTypes.NULL();
    private final DataTypeLookup lookup;
    private final String name;
    private final FunctionDefinition functionDefinition;
    private final List<DataType> argumentDataTypes;

    public UnknownCallContext(DataTypeLookup lookup, String name, FunctionDefinition functionDefinition, final int argumentCount) {
        this.lookup = lookup;
        this.name = name;
        this.functionDefinition = functionDefinition;
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int index) {
                return NULL;
            }

            @Override
            public int size() {
                return argumentCount;
            }
        };
    }

    @Override
    public DataTypeLookup getDataTypeLookup() {
        return this.lookup;
    }

    @Override
    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    @Override
    public boolean isArgumentLiteral(int pos) {
        return false;
    }

    @Override
    public boolean isArgumentNull(int pos) {
        return false;
    }

    @Override
    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        return Optional.empty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    @Override
    public Optional<DataType> getOutputDataType() {
        return Optional.empty();
    }
}

