/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.FileSystemTableSink;
import org.apache.flink.connector.file.table.FileSystemTableSource;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.utils.FactoryMocks;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class FileSystemTableFactoryTest {
    private static final ResolvedSchema SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.STRING()), Column.physical((String)"f1", (DataType)DataTypes.BIGINT()), Column.physical((String)"f2", (DataType)DataTypes.BIGINT())});

    FileSystemTableFactoryTest() {
    }

    @Test
    void testSourceSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "testcsv");
        descriptor.putString("testcsv.my_option", "my_value");
        DynamicTableSource source = FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap());
        Assertions.assertThat((Object)source).isInstanceOf(FileSystemTableSource.class);
        DynamicTableSink sink = FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, (Map)descriptor.asMap());
        Assertions.assertThat((Object)sink).isInstanceOf(FileSystemTableSink.class);
    }

    @Test
    void testLackOptionSource() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Missing required options are:\n\nformat")});
    }

    @Test
    void testLackOptionSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Missing required options are:\n\nformat")});
    }

    @Test
    void testUnsupportedOptionSource() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "csv");
        descriptor.putString("my_option", "my");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Unsupported options:\n\nmy_option")});
    }

    @Test
    void testUnsupportedOptionSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "csv");
        descriptor.putString("my_option", "my");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Unsupported options:\n\nmy_option")});
    }

    @Test
    void testUnsupportedWatermarkTimeZone() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "csv");
        descriptor.putString(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE.key(), "UTC+8");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Invalid time zone for 'sink.partition-commit.watermark-time-zone'.")});
    }

    @Test
    void testNoFormatFactoryFound() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "invalid");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Could not find any format factory for identifier 'invalid' in the classpath.")});
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Could not find any format factory for identifier 'invalid' in the classpath.")});
    }

    @Test
    void testFormatOptionsError() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "test-format");
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"One or more required options are missing.\n\nMissing required options are:\n\ndelimiter")});
        Assertions.assertThatThrownBy(() -> FactoryMocks.createTableSink((ResolvedSchema)SCHEMA, (Map)descriptor.asMap())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"One or more required options are missing.\n\nMissing required options are:\n\ndelimiter")});
    }

    @Test
    void testSupportsMetadata() {
        HashMap<String, String> descriptor = new HashMap<String, String>();
        descriptor.put(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.put("path", "/tmp");
        descriptor.put("format", "testcsv");
        descriptor.put("testcsv.my_option", "my_value");
        DynamicTableSource source = FactoryMocks.createTableSource((ResolvedSchema)SCHEMA, descriptor);
        Assertions.assertThat((Object)source).isInstanceOf(FileSystemTableSource.class);
        HashMap<String, AbstractDataType> readableMetadata = new HashMap<String, AbstractDataType>();
        readableMetadata.put("file.path", DataTypes.STRING().notNull());
        readableMetadata.put("file.name", DataTypes.STRING().notNull());
        readableMetadata.put("file.size", DataTypes.BIGINT().notNull());
        readableMetadata.put("file.modification-time", DataTypes.TIMESTAMP_LTZ((int)3).notNull());
        Assertions.assertThat((Map)((FileSystemTableSource)source).listReadableMetadata()).isEqualTo(readableMetadata);
    }
}

