/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileSystemTableSourceStreamingITCase
extends StreamingTestBase {
    FileSystemTableSourceStreamingITCase() {
    }

    @Test
    void testMonitorContinuously() throws Exception {
        File testPath = TempDirUtils.newFolder((Path)this.tempFolder());
        Files.write(Paths.get(testPath.getPath(), "input_0.csv"), Arrays.asList("1", "2", "3"), StandardOpenOption.CREATE);
        Duration monitorInterval = Duration.ofSeconds(1L);
        this.tEnv().createTable("my_streaming_table", TableDescriptor.forConnector((String)"filesystem").schema(Schema.newBuilder().column("data", (AbstractDataType)DataTypes.INT()).build()).format("testcsv").option(FileSystemConnectorOptions.PATH, (Object)testPath.getPath()).option(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL, (Object)monitorInterval).build());
        ArrayList<Object> actual = new ArrayList<Object>();
        try (CloseableIterator resultsIterator = this.tEnv().sqlQuery("SELECT * FROM my_streaming_table").execute().collect();){
            int i;
            for (i = 0; i < 3; ++i) {
                actual.add(((Row)resultsIterator.next()).getFieldAs(0));
            }
            Files.write(Paths.get(testPath.getPath(), "input_1.csv"), Arrays.asList("4", "5", "6"), StandardOpenOption.CREATE);
            for (i = 0; i < 3; ++i) {
                actual.add(((Row)resultsIterator.next()).getFieldAs(0));
            }
        }
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
    }

    @Test
    void testSourceWithRegexPattern() throws Exception {
        File testPath0 = TempDirUtils.newFolder((Path)this.tempFolder(), (String[])new String[]{"dir0"});
        File testPath1 = TempDirUtils.newFolder((Path)this.tempFolder(), (String[])new String[]{"dir1"});
        Files.write(Paths.get(testPath0.getPath(), "input_0.csv"), Arrays.asList("1", "2", "3"), StandardOpenOption.CREATE);
        Files.write(Paths.get(testPath1.getPath(), "input_0.csv"), Arrays.asList("4", "5", "6"), StandardOpenOption.CREATE);
        Files.write(Paths.get(testPath0.getPath(), "input_0.txt"), Arrays.asList("1", "2", "3"), StandardOpenOption.CREATE);
        Duration monitorInterval = Duration.ofSeconds(1L);
        this.tEnv().createTable("my_streaming_table", TableDescriptor.forConnector((String)"filesystem").schema(Schema.newBuilder().column("data", (AbstractDataType)DataTypes.INT()).build()).format("testcsv").option(FileSystemConnectorOptions.PATH, (Object)this.tempFolder().toFile().getPath()).option(FileSystemConnectorOptions.SOURCE_PATH_REGEX_PATTERN, (Object)"/.*/input_[0-9]+.csv").option(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL, (Object)monitorInterval).build());
        ArrayList<Object> actual = new ArrayList<Object>();
        try (CloseableIterator resultsIterator = this.tEnv().sqlQuery("SELECT * FROM my_streaming_table").execute().collect();){
            int i;
            for (i = 0; i < 6; ++i) {
                actual.add(((Row)resultsIterator.next()).getFieldAs(0));
            }
            Files.write(Paths.get(testPath0.getPath(), "input_1.csv"), Arrays.asList("7", "8", "9"), StandardOpenOption.CREATE);
            for (i = 0; i < 3; ++i) {
                actual.add(((Row)resultsIterator.next()).getFieldAs(0));
            }
        }
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
    }
}

