/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.testcsv;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.InstantiationUtil;

class TestCsvDeserializationSchema
implements DeserializationSchema<RowData> {
    private final List<DataType> physicalFieldTypes;
    private final int physicalFieldCount;
    private final TypeInformation<RowData> typeInfo;
    private final int[] indexMapping;
    private final DynamicTableSource.DataStructureConverter[] csvRowToRowDataConverters;
    private transient FieldParser<?>[] fieldParsers;

    public TestCsvDeserializationSchema(DataType physicalDataType, TypeInformation<RowData> typeInfo, List<String> orderedCsvColumns, Function<DataType, DynamicTableSource.DataStructureConverter> converterFactory) {
        this.physicalFieldTypes = DataType.getFieldDataTypes((DataType)physicalDataType);
        this.physicalFieldCount = this.physicalFieldTypes.size();
        this.typeInfo = typeInfo;
        List physicalFieldNames = DataType.getFieldNames((DataType)physicalDataType);
        this.indexMapping = orderedCsvColumns.stream().mapToInt(physicalFieldNames::indexOf).toArray();
        int csvRowLength = this.indexMapping.length;
        this.csvRowToRowDataConverters = new DynamicTableSource.DataStructureConverter[csvRowLength];
        for (int csvColumn = 0; csvColumn < csvRowLength; ++csvColumn) {
            if (this.indexMapping[csvColumn] == -1) continue;
            DataType fieldType = this.physicalFieldTypes.get(this.indexMapping[csvColumn]);
            this.csvRowToRowDataConverters[csvColumn] = converterFactory.apply(fieldType);
        }
        this.initFieldParsers();
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.initFieldParsers();
    }

    public RowData deserialize(byte[] message) throws IOException {
        GenericRowData row = new GenericRowData(this.physicalFieldCount);
        int startIndex = 0;
        for (int csvColumn = 0; csvColumn < this.indexMapping.length; ++csvColumn) {
            startIndex = this.fieldParsers[csvColumn].resetErrorStateAndParse(message, startIndex, message.length, new byte[]{44}, null);
            if (this.indexMapping[csvColumn] == -1) continue;
            row.setField(this.indexMapping[csvColumn], this.csvRowToRowDataConverters[csvColumn].toInternal(this.fieldParsers[csvColumn].getLastResult()));
        }
        return row;
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.typeInfo;
    }

    private void initFieldParsers() {
        int csvRowLength = this.indexMapping.length;
        this.fieldParsers = new FieldParser[csvRowLength];
        for (int csvColumn = 0; csvColumn < csvRowLength; ++csvColumn) {
            FieldParser p;
            if (this.indexMapping[csvColumn] == -1) {
                this.fieldParsers[csvColumn] = (FieldParser)InstantiationUtil.instantiate((Class)FieldParser.getParserForType(String.class), FieldParser.class);
                continue;
            }
            DataType fieldType = this.physicalFieldTypes.get(this.indexMapping[csvColumn]);
            Class parserType = FieldParser.getParserForType(this.logicalTypeRootToFieldParserClass(fieldType.getLogicalType().getTypeRoot()));
            if (parserType == null) {
                throw new RuntimeException("No parser available for type '" + fieldType + "'.");
            }
            this.fieldParsers[csvColumn] = p = (FieldParser)InstantiationUtil.instantiate((Class)parserType, FieldParser.class);
        }
    }

    private Class<?> logicalTypeRootToFieldParserClass(LogicalTypeRoot root) {
        switch (root) {
            case CHAR: 
            case VARCHAR: {
                return String.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return Time.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return Timestamp.class;
            }
        }
        throw new RuntimeException("The provided type " + root + " is not supported by the testcsv format");
    }
}

