/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExecuteSqlTest$;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u00015\u0011a\"\u0012=fGV$XmU9m)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0019\tA!\u001e;jY&\u00111\u0003\u0005\u0002\u000b)\u0016\u001cH\u000fT8hO\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\rA\u0006\u0005\nG\u0001\u0001\r\u00111A\u0005\u0002\u0011\n!\u0002^3na\u001a{G\u000eZ3s+\u0005)\u0003C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u00111\u0017\u000e\\3\u000b\u0005)Z\u0013a\u00018j_*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018(\u0005\u0011\u0001\u0016\r\u001e5\t\u0013A\u0002\u0001\u0019!a\u0001\n\u0003\t\u0014A\u0004;f[B4u\u000e\u001c3fe~#S-\u001d\u000b\u0003eU\u0002\"aF\u001a\n\u0005QB\"\u0001B+oSRDqAN\u0018\u0002\u0002\u0003\u0007Q%A\u0002yIEB\u0011\u0002\u000f\u0001A\u0002\u0003\u0005\u000b\u0015B\u0013\u0002\u0017Q,W\u000e\u001d$pY\u0012,'\u000f\t\u0015\u0003oi\u0002\"aO\"\u000e\u0003qR!!\u0010 \u0002\u0005%|'BA\u0002@\u0015\t\u0001\u0015)A\u0004kkBLG/\u001a:\u000b\u0005\tS\u0011!\u00026v]&$\u0018B\u0001#=\u0005\u001d!V-\u001c9ESJDqA\u0012\u0001C\u0002\u0013%q)\u0001\u0005tKR$\u0018N\\4t+\u0005A\u0005C\u0001\u0011J\u0013\tQ%AA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004M\u0001\u0001\u0006I\u0001S\u0001\ng\u0016$H/\u001b8hg\u0002BqA\u0014\u0001A\u0002\u0013\u0005q*\u0001\u0003u\u000b:4X#\u0001)\u0011\u0005\u0001\n\u0016B\u0001*\u0003\u0005A!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG\u000fC\u0004U\u0001\u0001\u0007I\u0011A+\u0002\u0011Q,eN^0%KF$\"A\r,\t\u000fY\u001a\u0016\u0011!a\u0001!\"1\u0001\f\u0001Q!\nA\u000bQ\u0001^#om\u0002BQA\u0017\u0001\u0005\u0002m\u000bq\u0002^3tiNCwn^\"pYVlgn\u001d\u000b\u0002e!\u0012\u0011,\u0018\t\u0003=~k\u0011AP\u0005\u0003Az\u0012A\u0002V3tiR+W\u000e\u001d7bi\u0016DQA\u0019\u0001\u0005\nm\u000b\u0001#\u001b8jiR\u000b'\r\\3B]\u00124\u0016.Z<\t\u000b\u0011\u0004A\u0011B.\u0002/MDwn^!mY\u000e{G.^7og\u001a\u0013x.\u001c+bE2,\u0007\"\u00024\u0001\t\u0013Y\u0016AI:i_^\u001cu\u000e\\;n]N<\u0016\u000e\u001e5MS.,7\t\\1vg\u00164%o\\7UC\ndW\rC\u0003i\u0001\u0011%1,A\u0013tQ><8i\u001c7v[:\u001cx+\u001b;i\u001d>$H*[6f\u00072\fWo]3Ge>lG+\u00192mK\")!\u000e\u0001C\u00057\u000612\u000f[8x\u00032d7i\u001c7v[:\u001chI]8n-&,w\u000fC\u0003m\u0001\u0011%1,A\u0011tQ><8i\u001c7v[:\u001cx+\u001b;i\u0019&\\Wm\u00117bkN,gI]8n-&,w\u000fC\u0003o\u0001\u0011%1,\u0001\u0013tQ><8i\u001c7v[:\u001cx+\u001b;i\u001d>$H*[6f\u00072\fWo]3Ge>lg+[3xQ\u0011\u0001\u0001O^<\u0011\u0005E$X\"\u0001:\u000b\u0005Mt\u0014!C3yi\u0016t7/[8o\u0013\t)(O\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d\u0013\u0001_\u0012\u0002sB\u0019!0!\u0002\u000e\u0003mT!\u0001`?\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\tqx0\u0001\u0006fqR,gn]5p]NT1AQA\u0001\u0015\r\t\u0019AB\u0001\ni\u0016\u001cH/\u001e;jYNL1!a\u0002|\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u001d\tYA\u0001E\u0001\u0003\u001b\ta\"\u0012=fGV$XmU9m)\u0016\u001cH\u000fE\u0002!\u0003\u001f1a!\u0001\u0002\t\u0002\u0005E1\u0003BA\b\u0003'\u00012aFA\u000b\u0013\r\t9\u0002\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000fu\ty\u0001\"\u0001\u0002\u001cQ\u0011\u0011Q\u0002\u0005\t\u0003?\ty\u0001\"\u0001\u0002\"\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005\r\u0002CBA\u0013\u0003S\ti#\u0004\u0002\u0002()\u0011\u0011cK\u0005\u0005\u0003W\t9C\u0001\u0006D_2dWm\u0019;j_:\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gY\u0013\u0001\u00027b]\u001eL1aGA\u0019Q!\ti\"!\u000f\u0002@\u0005\u0005\u0003c\u0001>\u0002<%\u0019\u0011QH>\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAA\"\u00031I7o\u0015;sK\u0006lWh\u001f\u0019~\u0001")
public class ExecuteSqlTest
extends TestLogger {
    private final boolean isStreaming;
    @TempDir
    private Path tempFolder;
    private final EnvironmentSettings settings;
    private TableEnvironment tEnv;

    @Parameters(name="isStream={0}")
    public static Collection<Boolean> parameters() {
        return ExecuteSqlTest$.MODULE$.parameters();
    }

    public Path tempFolder() {
        return this.tempFolder;
    }

    public void tempFolder_$eq(Path x$1) {
        this.tempFolder = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    @TestTemplate
    public void testShowColumns() {
        this.initTableAndView();
        this.showAllColumnsFromTable();
        this.showColumnsWithLikeClauseFromTable();
        this.showColumnsWithNotLikeClauseFromTable();
        this.showAllColumnsFromView();
        this.showColumnsWithLikeClauseFromView();
        this.showColumnsWithNotLikeClauseFromView();
    }

    private void initTableAndView() {
        String createClause = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE IF NOT EXISTS orders (\n         | `user` BIGINT NOT NULl,\n         | `product` VARCHAR(32),\n         | `amount` INT,\n         | PRIMARY KEY(`user`) NOT ENFORCED\n         |) ")).stripMargin();
        String createWithClause = new StringOps(Predef$.MODULE$.augmentString("\n         |with (\n         | 'connector' = 'datagen'\n         |)")).stripMargin();
        if (!this.isStreaming) {
            String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
            createWithClause = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n                            |with (\n                            |  'connector' = 'filesystem',\n                            |  'path' = '").append(sinkPath).append("',\n                            |  'format' = 'testcsv'\n                            |)").toString())).stripMargin();
        }
        this.tEnv().executeSql(new StringBuilder(0).append(createClause).append(createWithClause).toString());
        this.tEnv().executeSql("create view orders_view as select * from orders");
    }

    private void showAllColumnsFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders not like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showAllColumnsFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view not like '%_r%'").collect());
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assertions.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    public ExecuteSqlTest(boolean isStreaming) {
        this.isStreaming = isStreaming;
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)this.settings());
    }
}

