/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0001\u0003\u00015\u0011a\u0003V1cY\u0016,eN^5s_:lWM\u001c;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u0004;bE2,WI\u001c<OC6,\u0007CA\f\u001f\u001d\tAB\u0004\u0005\u0002\u001a!5\t!D\u0003\u0002\u001c\u0019\u00051AH]8pizJ!!\b\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;AA\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\fSN\u001cFO]3b[&tw\r\u0005\u0002\u0010I%\u0011Q\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000bU1\u0003\u0019\u0001\f\t\u000b\t2\u0003\u0019A\u0012\t\u00139\u0002\u0001\u0019!a\u0001\n\u0003y\u0013A\u0003;f[B4u\u000e\u001c3feV\t\u0001\u0007\u0005\u00022q5\t!G\u0003\u00024i\u0005!a-\u001b7f\u0015\t)d'A\u0002oS>T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t!\u0001+\u0019;i\u0011%Y\u0004\u00011AA\u0002\u0013\u0005A(\u0001\buK6\u0004hi\u001c7eKJ|F%Z9\u0015\u0005u\u0002\u0005CA\b?\u0013\ty\u0004C\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00031\u0003-!X-\u001c9G_2$WM\u001d\u0011)\u0005\t+\u0005C\u0001$O\u001b\u00059%B\u0001%J\u0003\tIwN\u0003\u0002\u0004\u0015*\u00111\nT\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti%\"A\u0003kk:LG/\u0003\u0002P\u000f\n9A+Z7q\t&\u0014\b\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0001S\u0003\u0011!XI\u001c<\u0016\u0003M\u0003\"A\u000b+\n\u0005U\u0013!\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011%9\u0006\u00011AA\u0002\u0013\u0005\u0001,\u0001\u0005u\u000b:4x\fJ3r)\ti\u0014\fC\u0004B-\u0006\u0005\t\u0019A*\t\u0013m\u0003\u0001\u0019!A!B\u0013\u0019\u0016!\u0002;F]Z\u0004\u0003bB/\u0001\u0005\u0004%IAX\u0001\tg\u0016$H/\u001b8hgV\tq\f\u0005\u0002+A&\u0011\u0011M\u0001\u0002\u0014\u000b:4\u0018N]8o[\u0016tGoU3ui&twm\u001d\u0005\u0007G\u0002\u0001\u000b\u0011B0\u0002\u0013M,G\u000f^5oON\u0004\u0003\"B3\u0001\t\u00031\u0017!B:fiV\u0004H#A\u001f)\u0005\u0011D\u0007CA5k\u001b\u0005I\u0015BA6J\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006[\u0002!\tAZ\u0001\"i\u0016\u001cH/\u0012=fGV$X\rV<jG\u0016,6/\u001b8h'\u0006lW\rV1cY\u0016,eN\u001e\u0015\u0003Y>\u0004\"!\u001b9\n\u0005EL%\u0001\u0004+fgR$V-\u001c9mCR,\u0007\"B:\u0001\t\u00031\u0017a\b;fgR,\u0005\u0010\u001d7bS:\fe\u000eZ#yK\u000e,H/Z*j]\u001edWmU5oW\"\u0012!o\u001c\u0005\u0006m\u0002!\tAZ\u0001\u001di\u0016\u001cH/\u0012=fGV$XmU9m/&$\b.\u00138tKJ$\u0018J\u001c;pQ\t)x\u000eC\u0003z\u0001\u0011\u0005a-A\u0011uKN$X\t_3dkR,7+\u001d7XSRD\u0017J\\:feR|e/\u001a:xe&$X\r\u000b\u0002y_\")A\u0010\u0001C\u0001M\u0006qB/Z:u\u000bb,7-\u001e;f'Fd\u0017I\u001c3Fq\u0016\u001cW\u000f^3J]N,'\u000f\u001e\u0015\u0003w>DQa \u0001\u0005\u0002\u0019\fQ\u0004^3ti\u0016CXmY;uKN\u000bH.\u00118e)>$\u0015\r^1TiJ,\u0017-\u001c\u0015\u0003}>Da!!\u0002\u0001\t\u00031\u0017!\b;fgR$v\u000eR1uCN#(/Z1n\u0003:$W\t_3dkR,7+\u001d7)\u0007\u0005\rq\u000e\u0003\u0004\u0002\f\u0001!\tAZ\u0001\"i\u0016\u001cHO\u0012:p[R{G)\u0019;b'R\u0014X-Y7B]\u0012,\u00050Z2vi\u0016\u001c\u0016\u000f\u001c\u0015\u0004\u0003\u0013y\u0007BBA\t\u0001\u0011\u0005a-A\tuKN$X\t_3dkR,\u0017J\\:feRD3!a\u0004p\u0011\u0019\t9\u0002\u0001C\u0001M\u0006\u0011B/Z:u\u000bb,7-\u001e;f\u0013:\u001cXM\u001d;3Q\r\t)b\u001c\u0005\u0007\u0003;\u0001A\u0011\u00014\u00025Q,7\u000f^#yK\u000e,H/Z%og\u0016\u0014Ho\u0014<fe^\u0014\u0018\u000e^3)\u0007\u0005mq\u000e\u0003\u0004\u0002$\u0001!\tAZ\u0001\u0011i\u0016\u001cH\u000fV1cY\u0016$U\nT*z]\u000eD3!!\tp\u0011\u0019\tI\u0003\u0001C\u0001M\u0006\u0001B/Z:u'R\fG/Z7f]R\u001cV\r\u001e\u0015\u0004\u0003Oy\u0007BBA\u0018\u0001\u0011\u0005a-A\fuKN$X\t_3dkR,7\u000b^1uK6,g\u000e^*fi\"\u001a\u0011QF8\t\r\u0005U\u0002\u0001\"\u0001g\u0003u!Xm\u001d;Ti\u0006$X-\\3oiN+GoV5uQ>3XM]<sSR,\u0007fAA\u001a_\"1\u00111\b\u0001\u0005\u0002\u0019\fa\u0005^3tiN#\u0018\r^3nK:$8+\u001a;XSRD7+Y7f'&t7\u000eV1cY\u0016t\u0015-\\3tQ\r\tId\u001c\u0005\u0007\u0003\u0003\u0002A\u0011\u00014\u0002#Q,7\u000f^#yK\u000e,H/Z*fY\u0016\u001cG\u000fK\u0002\u0002@=Dq!a\u0012\u0001\t\u0003\tI%A\ruKN$X\t_3dkR,7+\u001a7fGRLe\u000e^3s]\u0006dGcA\u001f\u0002L!9\u0011QJA#\u0001\u00041\u0012!B9vKJL\bBBA)\u0001\u0011\u0005a-\u0001\u0012uKN$X\t_3dkR,7+\u001a7fGR<\u0016\u000e\u001e5Va\u0012\fG/Z\"iC:<Wm\u001d\u0015\u0004\u0003\u001fz\u0007BBA,\u0001\u0011\u0005a-\u0001\u0012uKN$X\t_3dkR,7+\u001a7fGR<\u0016\u000e\u001e5US6,\u0017\t\u001e;sS\n,H/\u001a\u0015\u0004\u0003+z\u0007BBA/\u0001\u0011\u0005a-\u0001\nuKN$8\t\\3be>\u0003XM]1uS>t\u0007fAA._\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014!D4fiB+'o]8o\t\u0006$\u0018-\u0006\u0002\u0002hA1\u0011\u0011NA:\u0003srA!a\u001b\u0002p9\u0019\u0011$!\u001c\n\u0003EI1!!\u001d\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001e\u0002x\t!A*[:u\u0015\r\t\t\b\u0005\t\n\u001f\u0005md#a \u0002\u0006ZI1!! \u0011\u0005\u0019!V\u000f\u001d7fiA\u0019q\"!!\n\u0007\u0005\r\u0005CA\u0002J]R\u00042aDAD\u0013\r\tI\t\u0005\u0002\u0007\t>,(\r\\3\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\u0006\t\u0012m]:feR4\u0015N]:u-\u0006dW/Z:\u0015\u0007u\n\t\nC\u0004\u0002\u0014\u0006-\u0005\u0019\u0001\f\u0002\u0017\r\u001chOR5mKB\u000bG\u000f\u001b\u0005\b\u0003/\u0003A\u0011BAM\u0003A\t7o]3si2\u000b7\u000f\u001e,bYV,7\u000fF\u0002>\u00037Cq!a%\u0002\u0016\u0002\u0007a\u0003C\u0004\u0002 \u0002!I!!)\u0002+\u001d,G/\u0012=qK\u000e$X\r\u001a'bgR4\u0016\r\\;fgV\u0011\u00111\u0015\t\u0006\u0003S\n\u0019H\u0006\u0005\b\u0003O\u0003A\u0011BAU\u00039\u0019\u0007.Z2l\u000b6\u0004H/\u001f$jY\u0016$2!PAV\u0011\u001d\t\u0019*!*A\u0002YAq!a,\u0001\t\u0013\t\t,\u0001\u0006eK2,G/\u001a$jY\u0016$2!PAZ\u0011\u001d\t),!,A\u0002Y\tA\u0001]1uQ\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016AE1tg\u0016\u0014HOR5mK:{G/\u0012=jgR$2!PA_\u0011\u001d\t),a.A\u0002YAq!!1\u0001\t\u0013\t\u0019-\u0001\fdQ\u0016\u001c7.\u00138tKJ$H+\u00192mKJ+7/\u001e7u)\u0015i\u0014QYAh\u0011!\t9-a0A\u0002\u0005%\u0017a\u0003;bE2,'+Z:vYR\u00042AKAf\u0013\r\tiM\u0001\u0002\f)\u0006\u0014G.\u001a*fgVdG\u000f\u0003\u0005\u0002R\u0006}\u0006\u0019AAj\u0003)1\u0017.\u001a7e\u001d\u0006lWm\u001d\t\u0005\u001f\u0005Ug#C\u0002\u0002XB\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0011\u001d\tY\u000e\u0001C\u0005\u0003;\f\u0001B]3bI\u001aKG.\u001a\u000b\u0005\u0003G\u000by\u000eC\u0004\u0002\u0014\u0006e\u0007\u0019\u0001\f)\u000f\u0001\t\u0019/a<\u0002rB!\u0011Q]Av\u001b\t\t9OC\u0002\u0002j&\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u00055\u0018q\u001d\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAAzG\t\t)\u0010\u0005\u0003\u0002x\n\u001dQBAA}\u0015\u0011\tY0!@\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\tyP!\u0001\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002N\u0005\u0007Q1A!\u0002\u0007\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0003\n\u0005e(A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>twa\u0002B\u0007\u0005!\u0005!qB\u0001\u0017)\u0006\u0014G.Z#om&\u0014xN\\7f]RLEkQ1tKB\u0019!F!\u0005\u0007\r\u0005\u0011\u0001\u0012\u0001B\n'\r\u0011\tB\u0004\u0005\bO\tEA\u0011\u0001B\f)\t\u0011y\u0001\u0003\u0005\u0003\u001c\tEA\u0011\u0001B\u000f\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0005?\u0001bA!\t\u0003(\t-RB\u0001B\u0012\u0015\r\u0011)CN\u0001\u0005kRLG.\u0003\u0003\u0003*\t\r\"AC\"pY2,7\r^5p]B\"!Q\u0006B\u001c!\u0015y!q\u0006B\u001a\u0013\r\u0011\t\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0005k\u00119\u0004\u0004\u0001\u0005\u0019\te\"\u0011DA\u0001\u0002\u0003\u0015\tAa\u000f\u0003\u0007}#\u0013'\u0005\u0003\u0003>\t\r\u0003cA\b\u0003@%\u0019!\u0011\t\t\u0003\u000f9{G\u000f[5oOB\u0019qB!\u0012\n\u0007\t\u001d\u0003CA\u0002B]fD\u0003B!\u0007\u0003L\tE#1\u000b\t\u0005\u0003o\u0014i%\u0003\u0003\u0003P\u0005e(A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\u0011)&\u0001\t|auT\u0014n]*ue\u0016\fW.P>2{\u0002")
public class TableEnvironmentITCase {
    private final String tableEnvName;
    private final boolean isStreaming;
    @TempDir
    private Path tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    public Path tempFolder() {
        return this.tempFolder;
    }

    public void tempFolder_$eq(Path x$1) {
        this.tempFolder = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @BeforeEach
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @TestTemplate
    public void testExecuteTwiceUsingSameTableEnv() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        table2.executeInsert("MySink2").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @TestTemplate
    public void testExplainAndExecuteSingleSink() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testExecuteSqlWithInsertInto() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testExecuteSqlWithInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testExecuteSqlAndExecuteInsert() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.tEnv().sqlQuery("select last from MyTable").executeInsert("MySink2").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @TestTemplate
    public void testExecuteSqlAndToDataStream() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        TableResult tableResult = streamTableEnv.executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.isInitialized());
        this.deleteFile(sink1Path);
        streamEnv.execute("test2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        this.assertFileNotExist(sink1Path);
    }

    @TestTemplate
    public void testToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStreamWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testFromToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        org.apache.flink.table.api.bridge.scala.StreamTableEnvironment streamTableEnv = StreamTableEnvironment$.MODULE$.create(streamEnv, this.settings());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(streamEnv.fromCollection(this.getPersonData(), (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.TableEnvironmentITCase$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(streamTableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last"))}));
        streamTableEnv.createTemporaryView("MyTable", t);
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        org.apache.flink.streaming.api.scala.DataStream resultSet = streamTableEnv.toDataStream(table);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdate.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdateWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues(sink1Path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testExecuteInsert() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        Table table = this.tEnv().sqlQuery("select first from MyTable");
        TableResult tableResult = table.executeInsert("MySink");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testExecuteInsert2() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("execute insert into MySink select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testExecuteInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @TestTemplate
    public void testTableDMLSync() {
        this.tEnv().getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sink1Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n         |create table MySink1 (\n         |  first string,\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink2 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink3Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink3 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink3Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first, last from MyTable").executeInsert("MySink1", false);
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink2 select first from MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink3 select last from MySink1");
        TableResult tableResult2 = stmtSet.execute();
        this.assertFirstValues(sink2Path);
        this.assertLastValues(sink3Path);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink2", "default_catalog.default_database.MySink3"}));
        tableResult1.await();
        tableResult2.await();
    }

    @TestTemplate
    public void testStatementSet() {
        Boolean bl;
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable")).addInsertSql("insert into MySink2 select last from MyTable");
        String actual = stmtSet.explain(new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSet.out");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        if (this.isStreaming) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSetWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)(Assertions.assertThatThrownBy(() -> stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})).hasMessageContaining("EXPLAIN PLAN_ADVICE is not supported under batch mode.") instanceof UnsupportedOperationException));
        }
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @TestTemplate
    public void testExecuteStatementSet() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("execute statement set begin\n                                        |insert into MySink1 select first from MyTable;\n                                        |insert into MySink2 select last from MyTable;\n                                        |end")).stripMargin());
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @TestTemplate
    public void testStatementSetWithOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sink1Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink1 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink2 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult1 = stmtSet.execute();
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true).addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult2 = stmtSet.execute();
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @TestTemplate
    public void testStatementSetWithSameSinkTableNames() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = TempDirUtils.newFolder((Path)this.tempFolder()).toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink select last from MyTable");
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink_1", "default_catalog.default_database.MySink_2"}));
    }

    @TestTemplate
    public void testExecuteSelect() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |execute select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query2);
    }

    public void testExecuteSelectInternal(String query) {
        TableResult tableResult = this.tEnv().executeSql(query);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testExecuteSelectWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testExecuteSelectWithTimeAttribute() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "pt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation sourceType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, sourceType, data, null, "pt", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", tableSource);
        TableResult tableResult = this.tEnv().executeSql("select * from T");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"pt", (DataType)DataTypes.TIMESTAMP_LTZ((int)3))}), (Object)tableResult.getResolvedSchema());
        CloseableIterator it = tableResult.collect();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        Row row = (Row)it.next();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)row.getArity());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Mary", (Object)row.getField(0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)it.hasNext());
    }

    @TestTemplate
    public void testClearOperation() {
        Object object;
        TestCollectionTableFactory$.MODULE$.reset();
        TableEnvironmentImpl tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        tableEnv.executeSql("create table dest1(x map<int,bigint>) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table dest2(x int) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table src(x int) with('connector' = 'COLLECTION')");
        try {
            tableEnv.executeSql("insert into dest1 select count(*) from src");
            object = org.junit.jupiter.api.Assertions.fail((String)"insert is expected to fail due to type mismatch");
        }
        catch (Exception exception) {
            object = BoxedUnit.UNIT;
        }
        tableEnv.executeSql("drop table dest1");
        tableEnv.executeSql("insert into dest2 select x from src").await();
    }

    public List<Tuple4<String, Object, Object, String>> getPersonData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"Mike", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)12.3), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)45.6), (Object)"Taylor"));
        data.$plus$eq((Object)new Tuple4((Object)"Sam", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)7.89), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Peter", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToDouble((double)0.12), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Liz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)34.5), (Object)"Williams"));
        data.$plus$eq((Object)new Tuple4((Object)"Sally", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToDouble((double)6.78), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToDouble((double)90.1), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Kelly", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToDouble((double)2.34), (Object)"Williams"));
        return data.toList();
    }

    private void assertFirstValues(String csvFilePath) {
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mike", "Bob", "Sam", "Peter", "Liz", "Sally", "Alice", "Kelly"}));
        List<String> actual = this.readFile(csvFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void assertLastValues(String csvFilePath) {
        List<String> actual = this.readFile(csvFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private List<String> getExpectedLastValues() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith", "Taylor", "Miller", "Smith", "Williams", "Miller", "Smith", "Williams"}));
    }

    private void checkEmptyFile(String csvFilePath) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.readFileUtf8((File)new File(csvFilePath)).isEmpty());
    }

    private void deleteFile(String path) {
        new File(path).delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(path).exists());
    }

    private void assertFileNotExist(String path) {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(path).exists());
    }

    private void checkInsertTableResult(TableResult tableResult, Seq<String> fieldNames) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList((Object[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class))), (Object)tableResult.getResolvedSchema().getColumnNames());
        CloseableIterator it = tableResult.collect();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        Seq affectedRowCounts = (Seq)fieldNames.map((Function1 & Serializable & scala.Serializable)x$1 -> -1L, Seq$.MODULE$.canBuildFrom());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Row.of((Object[])((Object[])affectedRowCounts.toArray(ClassTag$.MODULE$.apply(Long.class)))), (Object)it.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)it.hasNext());
    }

    private List<String> readFile(String csvFilePath) {
        File file = new File(csvFilePath);
        return file.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles(new FileFilter(null){

            public boolean accept(File f) {
                return f.isFile();
            }
        }))).map((Function1 & Serializable & scala.Serializable)x$1 -> FileUtils.readFileUtf8((File)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split("\n"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtils.readFileUtf8((File)file).split("\n"))).toList();
    }

    public TableEnvironmentITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

