/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\u000bU$\u0018\u000e\\:\u000b\u0005M!\u0011a\u00029mC:tWM]\u0005\u0003+A\u0011q\u0002V1cY\u0016LEkQ1tK\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tA\u0011\u0002\b\u0001A\u0002\u0003\u0007I\u0011A\u000f\u0002\u0019Q\f'\r\\3F]Zt\u0015-\\3\u0016\u0003y\u0001\"a\b\u0015\u000f\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\r\u0003\u0019a$o\\8u})\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9C\u0005C\u0005-\u0001\u0001\u0007\t\u0019!C\u0001[\u0005\u0001B/\u00192mK\u0016sgOT1nK~#S-\u001d\u000b\u0003]I\u0002\"a\f\u0019\u000e\u0003\u0011J!!\r\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bg-\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\nk\u0001\u0001\r\u0011!Q!\ny\tQ\u0002^1cY\u0016,eN\u001e(b[\u0016\u0004\u0003\u0006\u0002\u001b8\u0007\u0012\u0003\"\u0001O!\u000e\u0003eR!AO\u001e\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\taT(\u0001\u0006fqR,gn]5p]NT!AP \u0002\u000b),h.\u001b;\u000b\u0005\u00013\u0011!\u0003;fgR,H/\u001b7t\u0013\t\u0011\u0015HA\u0005QCJ\fW.\u001a;fe\u0006)a/\u00197vKv\t\u0001\u0001C\u0005G\u0001\u0001\u0007\t\u0019!C\u0001\u000f\u0006Y\u0011n]*ue\u0016\fW.\u001b8h+\u0005A\u0005CA\u0018J\u0013\tQEEA\u0004C_>dW-\u00198\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015aD5t'R\u0014X-Y7j]\u001e|F%Z9\u0015\u00059r\u0005bB\u001aL\u0003\u0003\u0005\r\u0001\u0013\u0005\n!\u0002\u0001\r\u0011!Q!\n!\u000bA\"[:TiJ,\u0017-\\5oO\u0002BCaT\u001cD%v\t\u0011\u0001C\u0005U\u0001\u0001\u0007\t\u0019!C\u0001+\u0006!A/\u00128w+\u00051\u0006C\u0001\u000eX\u0013\tA&A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"I!\f\u0001a\u0001\u0002\u0004%\taW\u0001\ti\u0016sgo\u0018\u0013fcR\u0011a\u0006\u0018\u0005\bge\u000b\t\u00111\u0001W\u0011%q\u0006\u00011A\u0001B\u0003&a+A\u0003u\u000b:4\b\u0005C\u0003a\u0001\u0011\u0005\u0011-A\u0003tKR,\b\u000fF\u0001/Q\ty6\r\u0005\u0002eS6\tQM\u0003\u0002\u0004M*\u0011q\r[\u0001\bUV\u0004\u0018\u000e^3s\u0015\tq$\"\u0003\u0002kK\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b1\u0004A\u0011A1\u0002\u0017Q,7\u000f^#yK\u000e,H/\u001a\u0015\u0003W:\u0004\"\u0001Z8\n\u0005A,'\u0001\u0004+fgR$V-\u001c9mCR,\u0007\"\u0002:\u0001\t\u0003\u0019\u0018\u0001\u0006;fgR\u001cu\u000e\u001c7fGR<\u0016\u000e\u001e5DY>\u001cX\r\u0006\u0002/i\")Q/\u001da\u0001m\u0006i1\r\\;ti\u0016\u00148\t\\5f]R\u00044a^A\u0002!\rAXp`\u0007\u0002s*\u0011!p_\u0001\baJ|wM]1n\u0015\tah!\u0001\u0004dY&,g\u000e^\u0005\u0003}f\u0014Qb\u00117vgR,'o\u00117jK:$\b\u0003BA\u0001\u0003\u0007a\u0001\u0001B\u0006\u0002\u0006Q\f\t\u0011!A\u0003\u0002\u0005\u001d!aA0%cE!\u0011\u0011BA\b!\ry\u00131B\u0005\u0004\u0003\u001b!#a\u0002(pi\"Lgn\u001a\t\u0004_\u0005E\u0011bAA\nI\t\u0019\u0011I\\=)\u0007Q\f9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\r),h.\u001b;6\u0015\r\t\tCB\u0001\u0005i\u0016\u001cH/\u0003\u0003\u0002&\u0005m!aE%oU\u0016\u001cGo\u00117vgR,'o\u00117jK:$\bFA9o\u0011\u0019\tY\u0003\u0001C\u0001C\u0006aB/Z:u\u000bb,7-\u001e;f/&$\b.\u00169eCR,7\t[1oO\u0016\u001c\bfAA\u0015]\"1\u0011\u0011\u0007\u0001\u0005\u0002\u0005\f1\u0004^3ti\u000e{G\u000e\\3di^KG\u000f['vYRL'k\\<uS6,\u0007fAA\u0018]\"2\u0001!a\u000eD\u0003\u0007\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{)\u0017!C3yi\u0016t7/[8o\u0013\u0011\t\t%a\u000f\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002F\r\u0012\u0011q\t\t\u0004q\u0005%\u0013bAA&s\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u001e9\u0011q\n\u0002\t\u0002\u0005E\u0013a\u0003+bE2,\u0017\nV\"bg\u0016\u00042AGA*\r\u0019\t!\u0001#\u0001\u0002VM!\u00111KA,!\ry\u0013\u0011L\u0005\u0004\u00037\"#AB!osJ+g\rC\u0004\u0018\u0003'\"\t!a\u0018\u0015\u0005\u0005E\u0003\u0002CA2\u0003'\"\t!!\u001a\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002hA1\u0011\u0011NA:\u0003oj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005kRLGN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\u0015\r{G\u000e\\3di&|g\u000e\r\u0003\u0002z\u0005\u0005\u0005#B\u0018\u0002|\u0005}\u0014bAA?I\t)\u0011I\u001d:bsB!\u0011\u0011AAA\t1\t\u0019)!\u0019\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryFE\r\u0015\t\u0003C\n9)!$\u0002\u0010B\u0019\u0001(!#\n\u0007\u0005-\u0015H\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u0011\u0011S\u0001\u0011wBj(([:TiJ,\u0017-\\\u001f|cu\u0004")
public class TableITCase
extends TableITCaseBase {
    @Parameter(value=0)
    private String tableEnvName;
    @Parameter(value=1)
    private boolean isStreaming;
    private TableEnvironment tEnv;

    @Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableITCase$.MODULE$.parameters();
    }

    public String tableEnvName() {
        return this.tableEnvName;
    }

    public void tableEnvName_$eq(String x$1) {
        this.tableEnvName = x$1;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public void isStreaming_$eq(boolean x$1) {
        this.isStreaming = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    @BeforeEach
    public void setup() {
        EnvironmentSettings settings = this.isStreaming() ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        String string = this.tableEnvName();
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)settings));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)settings));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName()).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @TestTemplate
    public void testExecute() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        tableResult.await();
        CloseableIterator it = tableResult.collect();
        List actual = CollectionUtil.iteratorToList((Iterator)it);
        it.close();
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testCollectWithClose(@InjectClusterClient ClusterClient<?> clusterClient) {
        String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n        |create table unbounded_source (\n        |  id int\n        |) with (\n        |  'connector' = 'datagen',\n        |  'number-of-rows' = '10000',\n        |  'rows-per-second' = '1' -- slow producing speed to make sure that\n        |                          -- source is not finished when job is cancelled\n        |)\n        |")).stripMargin();
        this.tEnv().executeSql(sourceDdl);
        String query = "select id from unbounded_source where mod(id, 2) = 0";
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        CloseableIterator it = tableResult.collect();
        it.close();
        JobClient jobClient = (JobClient)tableResult.getJobClient().get();
        JobID jobId = jobClient.getJobID();
        clusterClient.requestJobResult(jobId).get();
        Assertions.assertEquals((Object)JobStatus.CANCELED, jobClient.getJobStatus().get());
    }

    @TestTemplate
    public void testExecuteWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assertions.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assertions.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assertions.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = this.isStreaming() ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assertions.assertEquals(expected, (Object)actual);
    }

    @TestTemplate
    public void testCollectWithMultiRowtime() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime1 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime2 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |SELECT MyTableWithRowtime1.ts, MyTableWithRowtime2.ts\n                        |FROM MyTableWithRowtime1, MyTableWithRowtime2\n                        |WHERE\n                        |  MyTableWithRowtime1.first = MyTableWithRowtime2.first AND\n                        |  MyTableWithRowtime1.ts = MyTableWithRowtime2.ts")).stripMargin());
        IndexedSeq expected = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 8).map((Function1 & Serializable & scala.Serializable)i -> TableITCase.$anonfun$testCollectWithMultiRowtime$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])((Object[])expected.toArray(ClassTag$.MODULE$.apply(Row.class)))));
    }

    public static final /* synthetic */ Row $anonfun$testCollectWithMultiRowtime$1(int i) {
        return Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{Instant.ofEpochMilli(i), Instant.ofEpochMilli(i)});
    }
}

