/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.batch.ExplainTest$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u00111\"\u0012=qY\u0006Lg\u000eV3ti*\u00111\u0001B\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000b\u0019\t1!\u00199j\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012!B;uS2\u001c(BA\u000b\u0007\u0003\u001d\u0001H.\u00198oKJL!a\u0006\n\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001C3yi\u0016tG-\u001a3\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005aQ\r\u001f;sC\u0012+G/Y5mgV\t\u0011\u0006E\u0002\u001cU1J!a\u000b\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u00055rS\"\u0001\u0003\n\u0005=\"!!D#ya2\f\u0017N\u001c#fi\u0006LG\u000e\u0003\u00042\u0001\u0001\u0006I!K\u0001\u000eKb$(/\u0019#fi\u0006LGn\u001d\u0011\t\u000fM\u0002!\u0019!C\u0005i\u0005!Q\u000f^5m+\u0005)\u0004CA\t7\u0013\t9$C\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007BB\u001d\u0001A\u0003%Q'A\u0003vi&d\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\rM#&+\u0013(H+\u0005i\u0004C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u001dawnZ5dC2T!A\u0011\u0004\u0002\u000bQL\b/Z:\n\u0005\u0011{$a\u0003,be\u000eC\u0017M\u001d+za\u0016DaA\u0012\u0001!\u0002\u0013i\u0014aB*U%&su\t\t\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0003\u0011auJT$\u0016\u0003)\u0003\"AP&\n\u00051{$A\u0003\"jO&sG\u000fV=qK\"1a\n\u0001Q\u0001\n)\u000bQ\u0001T(O\u000f\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+A\u0002J\u001dR+\u0012A\u0015\t\u0003}MK!\u0001V \u0003\u000f%sG\u000fV=qK\"1a\u000b\u0001Q\u0001\nI\u000bA!\u0013(UA!)\u0001\f\u0001C\u00013\u00061!-\u001a4pe\u0016$\u0012A\u0017\t\u00037mK!\u0001\u0018\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003/z\u0003\"aX3\u000e\u0003\u0001T!!B1\u000b\u0005\t\u001c\u0017a\u00026va&$XM\u001d\u0006\u0003I2\tQA[;oSRL!A\u001a1\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003i\u0001\u0011\u0005\u0011,\u0001\u0010uKN$X\t\u001f9mC&tw+\u001b;i)\u0006\u0014G.Z*pkJ\u001cWmU2b]\"\u0012qM\u001b\t\u0003?.L!\u0001\u001c1\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000b9\u0004A\u0011A-\u0002;Q,7\u000f^#ya2\f\u0017N\\,ji\"$\u0015\r^1TiJ,\u0017-\\*dC:D#!\u001c6\t\u000bE\u0004A\u0011A-\u0002+Q,7\u000f^#ya2\f\u0017N\\,ji\"4\u0015\u000e\u001c;fe\"\u0012\u0001O\u001b\u0005\u0006i\u0002!\t!W\u0001\u0013i\u0016\u001cH/\u0012=qY\u0006LgnV5uQ\u0006;w\r\u000b\u0002tU\")q\u000f\u0001C\u00013\u0006\u0019B/Z:u\u000bb\u0004H.Y5o/&$\bNS8j]\"\u0012aO\u001b\u0005\u0006u\u0002!\t!W\u0001\u0015i\u0016\u001cH/\u0012=qY\u0006LgnV5uQVs\u0017n\u001c8)\u0005eT\u0007\"B?\u0001\t\u0003I\u0016a\u0005;fgR,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5T_J$\bF\u0001?k\u0011\u0019\t\t\u0001\u0001C\u00013\u0006IB/Z:u\u000bb\u0004H.Y5o/&$\bnU5oO2,7+\u001b8lQ\ty(\u000e\u0003\u0004\u0002\b\u0001!\t!W\u0001\u001ai\u0016\u001cH/\u0012=qY\u0006LgnV5uQ6+H\u000e^5TS:\\7\u000fK\u0002\u0002\u0006)Da!!\u0004\u0001\t\u0003I\u0016\u0001\u0007;fgR,\u0005\u0010\u001d7bS:lU\u000f\u001c;ja2,\u0017J\u001c9vi\"\u001a\u00111\u00026)\u000f\u0001\t\u0019\"a\b\u0002\"A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0001\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAA\u0012G\t\t)\u0003\u0005\u0003\u0002(\u0005]RBAA\u0015\u0015\u0011\tY#!\f\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\ty#!\r\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002e\u0003gQ1!!\u000e\t\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0002:\u0005%\"A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>twaBA\u001f\u0005!\u0005\u0011qH\u0001\f\u000bb\u0004H.Y5o)\u0016\u001cH\u000fE\u0002%\u0003\u00032a!\u0001\u0002\t\u0002\u0005\r3\u0003BA!\u0003\u000b\u00022aGA$\u0013\r\tI\u0005\b\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005\n\t\u0005\"\u0001\u0002NQ\u0011\u0011q\b\u0005\t\u0003#\n\t\u0005\"\u0001\u0002T\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005U\u0003#BA,\u0003?RRBAA-\u0015\r\u0019\u00141\f\u0006\u0003\u0003;\nAA[1wC&!\u0011\u0011MA-\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0015\t\u0003\u001f\n)'a\u001b\u0002nA!\u0011qEA4\u0013\u0011\tI'!\u000b\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAA8\u00031)\u0007\u0010^3oI\u0016$Wh\u001f\u0019~\u0001")
public class ExplainTest
extends TableTestBase {
    private final ExplainDetail[] extraDetails;
    private final BatchTableTestUtil util;
    private final VarCharType STRING;
    private final BigIntType LONG;
    private final IntType INT;

    @Parameters(name="extended={0}")
    public static Collection<Object> parameters() {
        return ExplainTest$.MODULE$.parameters();
    }

    private ExplainDetail[] extraDetails() {
        return this.extraDetails;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    public VarCharType STRING() {
        return this.STRING;
    }

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @TestTemplate
    public void testExplainWithTableSourceScan() {
        this.util().verifyExplain("SELECT * FROM MyTable", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithDataStreamScan() {
        this.util().verifyExplain("SELECT * FROM MyTable1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithFilter() {
        this.util().verifyExplain("SELECT * FROM MyTable1 WHERE mod(a, 2) = 0", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithAgg() {
        this.util().verifyExplain("SELECT COUNT(*) FROM MyTable1 GROUP BY a", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, NestedLoopJoin");
        this.util().verifyExplain("SELECT a, b, c, e, f FROM MyTable1, MyTable2 WHERE a = d", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithUnion() {
        this.util().verifyExplain("SELECT * FROM MyTable1 UNION ALL SELECT * FROM MyTable2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSort() {
        this.util().verifyExplain("SELECT * FROM MyTable1 ORDER BY a LIMIT 5", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSingleSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT * FROM MyTable1 WHERE a > 10");
        TableSink<Row> sink = this.util().createCollectTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        this.util().verifyExplainInsert(table, sink, "sink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithMultiSinks() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable1 GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt > 10");
        TableSink<Row> sink1 = this.util().createCollectTableSink((String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("sink1", sink1);
        stmtSet.addInsert("sink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt < 10");
        TableSink<Row> sink2 = this.util().createCollectTableSink((String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("sink2", sink2);
        stmtSet.addInsert("sink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainMultipleInput() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   (select a, sum(b) from MyTable1 group by a) v1,\n        |   (select d, sum(e) from MyTable2 group by d) v2\n        |   where a = d\n        |")).stripMargin();
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    public ExplainTest(boolean extended) {
        this.extraDetails = extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE, ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.ExplainTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.ExplainTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.batch.ExplainTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.STRING = VarCharType.STRING_TYPE;
        this.LONG = new BigIntType();
        this.INT = new IntType();
    }
}

