/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.stream.ExplainTest$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u00111\"\u0012=qY\u0006Lg\u000eV3ti*\u00111\u0001B\u0001\u0007gR\u0014X-Y7\u000b\u0005\u00151\u0011aA1qS*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tb#D\u0001\u0013\u0015\t\u0019B#A\u0003vi&d7O\u0003\u0002\u0016\r\u00059\u0001\u000f\\1o]\u0016\u0014\u0018BA\f\u0013\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0005fqR,g\u000eZ3e!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001d\u0011un\u001c7fC:DQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u0003\u0011\u0015I\u0002\u00051\u0001\u001b\u0011\u001d9\u0003A1A\u0005\n!\nA\"\u001a=ue\u0006$U\r^1jYN,\u0012!\u000b\t\u00047)b\u0013BA\u0016\u001d\u0005\u0015\t%O]1z!\tic&D\u0001\u0005\u0013\tyCAA\u0007FqBd\u0017-\u001b8EKR\f\u0017\u000e\u001c\u0005\u0007c\u0001\u0001\u000b\u0011B\u0015\u0002\u001b\u0015DHO]1EKR\f\u0017\u000e\\:!\u0011\u001d\u0019\u0004A1A\u0005\nQ\nA!\u001e;jYV\tQ\u0007\u0005\u0002\u0012m%\u0011qG\u0005\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007s\u0001\u0001\u000b\u0011B\u001b\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000fm\u0002!\u0019!C\u0001y\u000511\u000b\u0016*J\u001d\u001e+\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002C\r\u0005)A/\u001f9fg&\u0011Ai\u0010\u0002\f-\u0006\u00148\t[1s)f\u0004X\r\u0003\u0004G\u0001\u0001\u0006I!P\u0001\b'R\u0013\u0016JT$!\u0011\u001dA\u0005A1A\u0005\u0002%\u000bA\u0001T(O\u000fV\t!\n\u0005\u0002?\u0017&\u0011Aj\u0010\u0002\u000b\u0005&<\u0017J\u001c;UsB,\u0007B\u0002(\u0001A\u0003%!*A\u0003M\u001f:;\u0005\u0005C\u0004Q\u0001\t\u0007I\u0011A)\u0002\u0007%sE+F\u0001S!\tq4+\u0003\u0002U\u007f\t9\u0011J\u001c;UsB,\u0007B\u0002,\u0001A\u0003%!+\u0001\u0003J\u001dR\u0003\u0003\"\u0002-\u0001\t\u0003I\u0016A\u00022fM>\u0014X\rF\u0001[!\tY2,\u0003\u0002]9\t!QK\\5uQ\t9f\f\u0005\u0002`K6\t\u0001M\u0003\u0002\u0006C*\u0011!mY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!G\"A\u0003kk:LG/\u0003\u0002gA\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b!\u0004A\u0011A-\u00025Q,7\u000f^#ya2\f\u0017N\u001c+bE2,7k\\;sG\u0016\u001c6-\u00198)\u0005\u001dT\u0007CA0l\u0013\ta\u0007M\u0001\u0007UKN$H+Z7qY\u0006$X\rC\u0003o\u0001\u0011\u0005\u0011,A\ruKN$X\t\u001f9mC&tG)\u0019;b'R\u0014X-Y7TG\u0006t\u0007FA7k\u0011\u0015\t\b\u0001\"\u0001Z\u0003U!Xm\u001d;FqBd\u0017-\u001b8XSRDg)\u001b7uKJD#\u0001\u001d6\t\u000bQ\u0004A\u0011A-\u0002%Q,7\u000f^#ya2\f\u0017N\\,ji\"\fum\u001a\u0015\u0003g*DQa\u001e\u0001\u0005\u0002e\u000b1\u0003^3ti\u0016C\b\u000f\\1j]^KG\u000f\u001b&pS:D#A\u001e6\t\u000bi\u0004A\u0011A-\u0002)Q,7\u000f^#ya2\f\u0017N\\,ji\",f.[8oQ\tI(\u000eC\u0003~\u0001\u0011\u0005\u0011,A\nuKN$X\t\u001f9mC&tw+\u001b;i'>\u0014H\u000f\u000b\u0002}U\"1\u0011\u0011\u0001\u0001\u0005\u0002e\u000b\u0011\u0004^3ti\u0016C\b\u000f\\1j]^KG\u000f[*j]\u001edWmU5oW\"\u0012qP\u001b\u0005\u0007\u0003\u000f\u0001A\u0011A-\u00023Q,7\u000f^#ya2\f\u0017N\\,ji\"lU\u000f\u001c;j'&t7n\u001d\u0015\u0004\u0003\u000bQ\u0007BBA\u0007\u0001\u0011\u0005\u0011,\u0001\u000euKN$X*\u001b8j\u0005\u0006$8\r[%oi\u0016\u0014h/\u00197J]\u001a,'\u000fK\u0002\u0002\f)Ds\u0001AA\n\u0003?\t\t\u0003\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\u0002Y\u0001\nKb$XM\\:j_:LA!!\b\u0002\u0018\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005\r2EAA\u0013!\u0011\t9#a\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA\u0018\u0003c\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r!\u00171\u0007\u0006\u0004\u0003kA\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\tI$!\u000b\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005u\"\u0001#\u0001\u0002@\u0005YQ\t\u001f9mC&tG+Z:u!\r!\u0013\u0011\t\u0004\u0007\u0003\tA\t!a\u0011\u0014\t\u0005\u0005\u0013Q\t\t\u00047\u0005\u001d\u0013bAA%9\t1\u0011I\\=SK\u001aDq!IA!\t\u0003\ti\u0005\u0006\u0002\u0002@!A\u0011\u0011KA!\t\u0003\t\u0019&\u0001\u0006qCJ\fW.\u001a;feN$\"!!\u0016\u0011\u000b\u0005]\u0013q\f\u000e\u000e\u0005\u0005e#bA\u001a\u0002\\)\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005e#AC\"pY2,7\r^5p]\"B\u0011qJA3\u0003W\ni\u0007\u0005\u0003\u0002(\u0005\u001d\u0014\u0002BA5\u0003S\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005=\u0014\u0001D3yi\u0016tG-\u001a3>wBj\b")
public class ExplainTest
extends TableTestBase {
    private final ExplainDetail[] extraDetails;
    private final StreamTableTestUtil util;
    private final VarCharType STRING;
    private final BigIntType LONG;
    private final IntType INT;

    @Parameters(name="extended={0}")
    public static Collection<Object> parameters() {
        return ExplainTest$.MODULE$.parameters();
    }

    private ExplainDetail[] extraDetails() {
        return this.extraDetails;
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    public VarCharType STRING() {
        return this.STRING;
    }

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @TestTemplate
    public void testExplainTableSourceScan() {
        this.util().verifyExplain("SELECT * FROM MyTable", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainDataStreamScan() {
        this.util().verifyExplain("SELECT * FROM MyTable1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithFilter() {
        this.util().verifyExplain("SELECT * FROM MyTable1 WHERE mod(a, 2) = 0", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithAgg() {
        this.util().verifyExplain("SELECT COUNT(*) FROM MyTable1 GROUP BY a", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithJoin() {
        this.util().verifyExplain("SELECT a, b, c, e, f FROM MyTable1, MyTable2 WHERE a = d", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithUnion() {
        this.util().verifyExplain("SELECT * FROM MyTable1 UNION ALL SELECT * FROM MyTable2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSort() {
        this.util().verifyExplain("SELECT * FROM MyTable1 ORDER BY a LIMIT 5", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSingleSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT * FROM MyTable1 WHERE a > 10");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        this.util().verifyExplainInsert(table, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithMultiSinks() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable1 GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt > 10");
        UpsertStreamTableSink<RowData> upsertSink1 = this.util().createUpsertTableSink(new int[]{0}, (String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink1", upsertSink1);
        stmtSet.addInsert("upsertSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt < 10");
        UpsertStreamTableSink<RowData> upsertSink2 = this.util().createUpsertTableSink(new int[]{0}, (String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink2", upsertSink2);
        stmtSet.addInsert("upsertSink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testMiniBatchIntervalInfer() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.ExplainTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "goods")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple6<Object, String, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple6<Object, String, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])), (Object)((Timestamp)fields[5]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple6<Object, String, Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.ExplainTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableWithWatermark("T3", this.util().tableEnv().from("T1"), "rowtime", 0L);
        this.util().addTableWithWatermark("T4", this.util().tableEnv().from("T2"), "rowtime", 0L);
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(3L));
        Table table = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                         |SELECT id1, T3.rowtime AS ts, text\n                                         |  FROM T3, T4\n                                         |WHERE id1 = id2\n                                         |      AND T3.rowtime > T4.rowtime - INTERVAL '5' MINUTE\n                                         |      AND T3.rowtime < T4.rowtime + INTERVAL '3' MINUTE\n      ")).stripMargin());
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                          |SELECT id1, LISTAGG(text, '#')\n                                          |FROM TempTable\n                                          |GROUP BY id1, TUMBLE(ts, INTERVAL '8' SECOND)\n      ")).stripMargin());
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                               |SELECT id1, LISTAGG(text, '*')\n                               |FROM TempTable\n                               |GROUP BY id1, HOP(ts, INTERVAL '12' SECOND, INTERVAL '6' SECOND)\n      ")).stripMargin());
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    public ExplainTest(boolean extended) {
        this.extraDetails = extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE, ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.ExplainTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.ExplainTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.ExplainTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.STRING = VarCharType.STRING_TYPE;
        this.LONG = new BigIntType();
        this.INT = new IntType();
    }
}

