/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlinkCalciteSqlValidatorTest {
    private final PlannerMocks plannerMocks = PlannerMocks.create().registerTemporaryTable("t1", Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).build());

    FlinkCalciteSqlValidatorTest() {
    }

    @Test
    void testUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }

    @Test
    void testExplainUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("EXPLAIN UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }
}

