/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.catalog.CatalogTableITCase$;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u0001=\u0011!cQ1uC2|w\rV1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tQ!\u001e;jYNL!!\u0006\n\u0003\u001fQ\u000b'\r\\3J)\u000e\u000b7/\u001a\"bg\u0016D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0010SN\u001cFO]3b[&tw-T8eKB\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t9!i\\8mK\u0006t\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0005!)qC\ba\u00011!9Q\u0005\u0001b\u0001\n\u00131\u0013\u0001C:fiRLgnZ:\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002-S\t\u0019RI\u001c<je>tW.\u001a8u'\u0016$H/\u001b8hg\"1a\u0006\u0001Q\u0001\n\u001d\n\u0011b]3ui&twm\u001d\u0011\t\u000fA\u0002!\u0019!C\u0005c\u0005AA/\u00192mK\u0016sg/F\u00013!\tA3'\u0003\u00025S\t\u0001B+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u0013Q\f'\r\\3F]Z\u0004\u0003\"\u0002\u001d\u0001\t\u0003I\u0014A\u00022fM>\u0014X\rF\u0001;!\tI2(\u0003\u0002=5\t!QK\\5uQ\t9d\b\u0005\u0002@\u000b6\t\u0001I\u0003\u0002+\u0003*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!E\"A\u0003kk:LG/\u0003\u0002G\u0001\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b!\u0003A1A%\u0002\u0017I|wo\u0014:eKJLgnZ\u000b\u0002\u0015B\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u000f\u0003\u0019a$o\\8u}%\t1$\u0003\u0002S5\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005!y%\u000fZ3sS:<'B\u0001*\u001b!\t9&,D\u0001Y\u0015\tI\u0006\"A\u0003usB,7/\u0003\u0002\\1\n\u0019!k\\<\t\u000bu\u0003A\u0011\u00010\u0002\u000bQ|'k\\<\u0015\u0005Y{\u0006\"\u00021]\u0001\u0004\t\u0017\u0001B1sON\u00042!\u00072e\u0013\t\u0019'D\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"!G3\n\u0005\u0019T\"aA!os\")\u0001\u000e\u0001C\u0001S\u0006yq-\u001a;UC\ndWm\u00149uS>t7\u000f\u0006\u0002kuB!1\u000e\u001d:s\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u0004\u001b\u0006\u0004\bCA:x\u001d\t!X\u000f\u0005\u0002N5%\u0011aOG\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002w5!)1p\u001aa\u0001e\u0006IA/\u00192mK:\u000bW.\u001a\u0005\u0006{\u0002!IA`\u0001\bi\u0016\u001cH/\u00163g)\tQt\u0010\u0003\u0004\u0002\u0002q\u0004\rA]\u0001\u000bMVt7\r\u0015:fM&D\bBBA\u0003\u0001\u0011\u0005\u0011(A\ruKN$X\u000b\u001a4XSRDg)\u001e7m\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0006BA\u0002\u0003\u0013\u00012aPA\u0006\u0013\r\ti\u0001\u0011\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0007\u0003#\u0001A\u0011A\u001d\u0002'Q,7\u000f^+eM^KG\u000f\u001b#bi\u0006\u0014\u0017m]3)\t\u0005=\u0011\u0011\u0002\u0005\u0007\u0003/\u0001A\u0011A\u001d\u0002\u001dQ,7\u000f^+eM^KG\u000f\u001b(p]\"\"\u0011QCA\u0005\u0011\u0019\ti\u0002\u0001C\u0001s\u00059B/Z:u+\u00124w+\u001b;i/J|gnZ\"bi\u0006dwn\u001a\u0015\u0005\u00037\tI\u0001\u0003\u0004\u0002$\u0001!\t!O\u0001\u0019i\u0016\u001cH/\u00163g/&$\bn\u0016:p]\u001e$\u0015\r^1cCN,\u0007\u0006BA\u0011\u0003\u0013Aa!!\u000b\u0001\t\u0003I\u0014A\u0004;fgRLen]3si&sGo\u001c\u0015\u0005\u0003O\tI\u0001\u0003\u0004\u00020\u0001!\t!O\u0001\u0019i\u0016\u001cHOU3bI^\u0013\u0018\u000e^3DgZ,6/\u001b8h\t\u0012c\u0005\u0006BA\u0017\u0003\u0013Aa!!\u000e\u0001\t\u0003I\u0014a\n;fgR\u0014V-\u00193Xe&$XmQ:w/&$\b\u000eR=oC6L7\rV1cY\u0016|\u0005\u000f^5p]NDC!a\r\u0002\n!1\u00111\b\u0001\u0005\u0002e\nQ\u0005^3ti&s7/\u001a:u'>,(oY3UC\ndW-\u0012=qe\u0016\u001c8/[8o\r&,G\u000eZ:)\t\u0005e\u0012\u0011\u0002\u0005\u0007\u0003\u0003\u0002A\u0011A\u001d\u0002kQ,7\u000f^%og\u0016\u0014HoU8ve\u000e,G+\u00192mK\u0016C\bO]3tg&|gNR5fY\u0012\u001c()\u001a4pe\u0016\u0014VMZ3sK:\u001cWm\u001d\u0015\u0005\u0003\u007f\tI\u0001\u0003\u0004\u0002H\u0001!\t!O\u0001#i\u0016\u001cH/\u00138tKJ$8k\\;sG\u0016$\u0016M\u00197f/&$\bNR;oG\u001aKW\r\u001c3)\t\u0005\u0015\u0013\u0011\u0002\u0005\u0007\u0003\u001b\u0002A\u0011A\u001d\u0002[Q,7\u000f^%og\u0016\u0014HoU8ve\u000e,G+\u00192mK^KG\u000f[+tKJ$UMZ5oK\u00124UO\\2GS\u0016dG\r\u000b\u0003\u0002L\u0005%\u0001BBA*\u0001\u0011\u0005\u0011(A\u0012uKN$\u0018J\\:feR\u001c\u0016N\\6UC\ndW-\u0012=qe\u0016\u001c8/[8o\r&,G\u000eZ:)\t\u0005E\u0013\u0011\u0002\u0005\u0007\u00033\u0002A\u0011A\u001d\u0002MQ,7\u000f^%og\u0016\u0014HoU5oWR\u000b'\r\\3XSRDWK\\7bi\u000eDW\r\u001a$jK2$7\u000f\u000b\u0003\u0002X\u0005%\u0001BBA0\u0001\u0011\u0005\u0011(\u0001\u000euKN$\u0018J\\:feR<\u0016\u000e\u001e5K_&tW\rZ*pkJ\u001cW\r\u000b\u0003\u0002^\u0005%\u0001BBA3\u0001\u0011\u0005\u0011(A\u000fuKN$\u0018J\\:feR<\u0016\u000e\u001e5BO\u001e\u0014XmZ1uKN{WO]2fQ\u0011\t\u0019'!\u0003\t\r\u0005-\u0004\u0001\"\u0001:\u0003A\"Xm\u001d;UK6\u0004xN]1ssR\u000b'\r\\3NCN\\\u0007+\u001a:nC:,g\u000e\u001e+bE2,w+\u001b;i'\u0006lWMT1nK\"\"\u0011\u0011NA\u0005\u0011\u0019\t\t\b\u0001C\u0001s\u0005IB/Z:u\tJ|\u0007\u000fV1cY\u0016<\u0016\u000e\u001e5Gk2d\u0007+\u0019;iQ\u0011\ty'!\u0003\t\r\u0005]\u0004\u0001\"\u0001:\u0003q!Xm\u001d;Ee>\u0004H+\u00192mK^KG\u000f\u001b)beRL\u0017\r\u001c)bi\"DC!!\u001e\u0002\n!1\u0011Q\u0010\u0001\u0005\u0002e\nA\u0004^3ti\u0012\u0013x\u000e\u001d+bE2,w+\u001b;i\u0013:4\u0018\r\\5e!\u0006$\b\u000e\u000b\u0003\u0002|\u0005%\u0001BBAB\u0001\u0011\u0005\u0011(\u0001\u0013uKN$HI]8q)\u0006\u0014G.Z,ji\"LeN^1mS\u0012\u0004\u0016\r\u001e5JM\u0016C\u0018n\u001d;tQ\u0011\t\t)!\u0003\t\r\u0005%\u0005\u0001\"\u0001:\u0003\u001d\"Xm\u001d;Ee>\u0004H+\u00192mKN\u000bW.\u001a(b[\u0016<\u0016\u000e\u001e5UK6\u0004xN]1ssR\u000b'\r\\3)\t\u0005\u001d\u0015\u0011\u0002\u0005\u0007\u0003\u001f\u0003A\u0011A\u001d\u0002;Q,7\u000f\u001e#s_B4\u0016.Z<TC6,g*Y7f/&$\b\u000eV1cY\u0016DC!!$\u0002\n!1\u0011Q\u0013\u0001\u0005\u0002e\n\u0001\u0006^3ti\u0012\u0013x\u000e\u001d,jK^\u001c\u0016-\\3OC6,w+\u001b;i)\u0006\u0014G.Z%g\u001d>$X\t_5tiNDC!a%\u0002\n!1\u00111\u0014\u0001\u0005\u0002e\na\u0002^3ti\u0006cG/\u001a:UC\ndW\r\u000b\u0003\u0002\u001a\u0006%\u0001BBAQ\u0001\u0011\u0005\u0011(A\u0011uKN$8I]3bi\u0016$\u0016M\u00197f\u0003:$7\u000b[8x\u0007J,\u0017\r^3UC\ndW\r\u000b\u0003\u0002 \u0006%\u0001BBAT\u0001\u0011\u0005\u0011(\u0001\u0017uKN$8I]3bi\u0016$\u0016M\u00197f/&$\bnQ8n[\u0016tG/\u00118e'\"|wo\u0011:fCR,G+\u00192mK\"\"\u0011QUA\u0005\u0011\u0019\ti\u000b\u0001C\u0001s\u0005\u0001C/Z:u\u0007J,\u0017\r^3WS\u0016<\u0018I\u001c3TQ><8I]3bi\u0016$\u0016M\u00197fQ\u0011\tY+!\u0003\t\r\u0005M\u0006\u0001\"\u0001:\u0003M!Xm\u001d;BYR,'OV5foJ+g.Y7fQ\u0011\t\t,!\u0003\t\r\u0005e\u0006\u0001\"\u0001:\u0003=!Xm\u001d;BYR,'OV5fo\u0006\u001b\b\u0006BA\\\u0003\u0013Aa!a0\u0001\t\u0003I\u0014a\t;fgR,6/Z\"bi\u0006dwnZ!oINCwn^\"veJ,g\u000e^\"bi\u0006dwn\u001a\u0015\u0005\u0003{\u000bI\u0001\u0003\u0004\u0002F\u0002!\t!O\u0001&i\u0016\u001cH/V:f\t\u0006$\u0018MY1tK\u0006sGm\u00155po\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016DC!a1\u0002\n!1\u00111\u001a\u0001\u0005\u0002e\n!\u0003^3ti\u000e\u0013X-\u0019;f\t\u0006$\u0018MY1tK\"\"\u0011\u0011ZA\u0005\u0011\u0019\t\t\u000e\u0001C\u0001s\u0005\u0001B/Z:u\tJ|\u0007\u000fR1uC\n\f7/\u001a\u0015\u0005\u0003\u001f\fI\u0001\u0003\u0004\u0002X\u0002!\t!O\u0001\u0012i\u0016\u001cH/\u00117uKJ$\u0015\r^1cCN,\u0007\u0006BAk\u0003\u0013Aa!!8\u0001\t\u0003I\u0014\u0001\u0005;fgRdu.\u00193Gk:\u001cG/[8oQ\u0011\tY.!\u0003)\u000f\u0001\t\u0019/a<\u0002rB!\u0011Q]Av\u001b\t\t9OC\u0002\u0002j\u0002\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u00055\u0018q\u001d\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAAzG\t\t)\u0010\u0005\u0003\u0002x\n\u001dQBAA}\u0015\u0011\tY0!@\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\tyP!\u0001\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002E\u0005\u0007Q1A!\u0002\t\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0003\n\u0005e(A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>twa\u0002B\u0007\u0005!\u0005!qB\u0001\u0013\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.Z%U\u0007\u0006\u001cX\rE\u0002#\u0005#1a!\u0001\u0002\t\u0002\tM1\u0003\u0002B\t\u0005+\u00012!\u0007B\f\u0013\r\u0011IB\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f}\u0011\t\u0002\"\u0001\u0003\u001eQ\u0011!q\u0002\u0005\t\u0005C\u0011\t\u0002\"\u0001\u0003$\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\t\u0015\u0002\u0003B6\u0003(aI1A!\u000bm\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0015\t\u0005?\u0011iCa\r\u00036A!\u0011q\u001fB\u0018\u0013\u0011\u0011\t$!?\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017E\u0001B\u001c\u0003\rY\b' ")
public class CatalogTableITCase
extends TableITCaseBase {
    private final boolean isStreamingMode;
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogTableITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    @BeforeEach
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
        CatalogFunctionImpl func = new CatalogFunctionImpl(JavaUserDefinedScalarFunctions.JavaFunc0.class.getName());
        ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).createFunction(new ObjectPath(this.tableEnv().getCurrentDatabase(), "myfunc"), (CatalogFunction)func, true);
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Row toRow(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    public Map<String, String> getTableOptions(String tableName) {
        return ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(new ObjectPath(this.tableEnv().getCurrentDatabase(), tableName)).getOptions();
    }

    private void testUdf(String funcPrefix) {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(159).append("\n         |create table sinkT(\n         |  a bigint\n         |) with (\n         |  'connector' = 'COLLECTION',\n         |  'is-bounded' = '").append(this.isStreamingMode).append("'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(new java.lang.StringBuilder(50).append("insert into sinkT select ").append(funcPrefix).append("myfunc(cast(1 as bigint))").toString()).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L)}))})), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testUdfWithFullIdentifier() {
        this.testUdf("default_catalog.default_database.");
    }

    @TestTemplate
    public void testUdfWithDatabase() {
        this.testUdf("default_database.");
    }

    @TestTemplate
    public void testUdfWithNon() {
        this.testUdf("");
    }

    @TestTemplate
    public void testUdfWithWrongCatalog() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testUdf("wrong_catalog.default_database."));
    }

    @TestTemplate
    public void testUdfWithWrongDatabase() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testUdf("default_catalog.wrong_database."));
    }

    @TestTemplate
    public void testInsertInto() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, (t1.a + 1) as c , d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testReadWriteCsvUsingDDL() {
        Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.02,Euro,2019-12-12 00:00:01.001001", "1.11,US Dollar,2019-12-12 00:00:02.002001", "50,Yen,2019-12-12 00:00:04.004001", "3.1,Euro,2019-12-12 00:00:05.005001", "5.33,US Dollar,2019-12-12 00:00:06.006001"}));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(439).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ',',\n         |  'format.line-delimiter' = '#'\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(361).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0,2019-12-12 00:00:04.004001,3,50.00\n2019-12-12 00:00:10.0,2019-12-12 00:00:06.006001,2,5.33\n";
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @TestTemplate
    public void testReadWriteCsvWithDynamicTableOptions() {
        Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.02,Euro,2019-12-12 00:00:01.001001", "1.11,US Dollar,2019-12-12 00:00:02.002001", "50,Yen,2019-12-12 00:00:04.004001", "3.1,Euro,2019-12-12 00:00:05.005001", "5.33,US Dollar,2019-12-12 00:00:06.006001"}));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(396).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(317).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2 /*+ OPTIONS('format.field-delimiter' = '|') */\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1 /*+ OPTIONS('format.line-delimiter' = '#') */\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0|2019-12-12 00:00:04.004001|3|50.00\n2019-12-12 00:00:10.0|2019-12-12 00:00:06.006001|2|5.33\n";
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @TestTemplate
    public void testInsertSourceTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableExpressionFieldsBeforeReferences() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)101), BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)103), BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  c as a + 100,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  c int,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.c, t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableWithFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", DateTimeTestUtil$.MODULE$.localDateTime("1990-02-10 12:34:56")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:41")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:42")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:43")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:44")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as to_timestamp(b)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c timestamp(3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableWithUserDefinedFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42", BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43", BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        this.tableEnv().createTemporarySystemFunction("my_udf", (UserDefinedFunction)Func0$.MODULE$);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  `time` varchar,\n        |  c as my_udf(a),\n        |  d as `time`\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  `time` varchar,\n        |  c int not null,\n        |  d varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.`time`, t1.c, t1.d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSinkTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as c - 1,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSinkTableWithUnmatchedFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as cast(a as varchar(20)) || cast(c as varchar(20)),\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql(query).await()).withMessageContaining("Incompatible types for sink column 'c' at position 1.");
    }

    @TestTemplate
    public void testInsertWithJoinedSource() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int,\n        |  c int,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select a.a, a.b, b.a, b.b\n        |  from t1 a\n        |  join t1 b\n        |  on a.a = b.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertWithAggregateSource() {
        if (this.isStreamingMode) {
            return;
        }
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)2000)})), (List)Nil$.MODULE$)));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select sum(a), t1.b from t1 group by t1.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testTemporaryTableMaskPermanentTableWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String permanentTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String temporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d as c+1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        .colon.colon permanentData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon temporaryData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(permanentTable);
        this.tableEnv().executeSql(temporaryTable);
        this.tableEnv().executeSql(sinkTable);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT a, b, d FROM T1";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)temporaryData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY TABLE IF EXISTS T1\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryTable);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)permanentData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testDropTableWithFullPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_catalog.default_database.t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testDropTableWithPartialPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        | 'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_database.t2");
        this.tableEnv().executeSql("DROP TABLE t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).isEmpty());
    }

    @TestTemplate
    public void testDropTableWithInvalidPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("DROP TABLE catalog1.database1.t1"));
    }

    @TestTemplate
    public void testDropTableWithInvalidPathIfExists() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        this.tableEnv().executeSql("DROP TABLE IF EXISTS catalog1.database1.t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testDropTableSameNameWithTemporaryTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String createTable2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql(createTable2);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("drop table t1")).withMessageContaining("Temporary table with identifier '`default_catalog`.`default_database`.`t1`' exists. Drop it first before removing the permanent table.");
    }

    @TestTemplate
    public void testDropViewSameNameWithTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("drop view t1")).withMessageContaining("View with identifier 'default_catalog.default_database.t1' does not exist.");
    }

    @TestTemplate
    public void testDropViewSameNameWithTableIfNotExists() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql("drop view if exists t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testAlterTable() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint not null,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'k1' = 'v1'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql("alter table t1 rename to t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})));
        this.tableEnv().executeSql("alter table t2 set ('k1' = 'a', 'k2' = 'b')");
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("connector", "COLLECTION");
        expectedOptions.put("k1", "a");
        expectedOptions.put("k2", "b");
        org.junit.jupiter.api.Assertions.assertEquals(expectedOptions, this.getTableOptions("t2"));
        this.tableEnv().executeSql("alter table t2 reset ('k1')");
        expectedOptions.remove("k1");
        org.junit.jupiter.api.Assertions.assertEquals(expectedOptions, this.getTableOptions("t2"));
        String currentCatalog = this.tableEnv().getCurrentCatalog();
        String currentDB = this.tableEnv().getCurrentDatabase();
        this.tableEnv().executeSql("alter table t2 add constraint ct1 primary key(a) not enforced");
        TableSchema tableSchema1 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        Predef$.MODULE$.assert(tableSchema1.getPrimaryKey().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"CONSTRAINT ct1 PRIMARY KEY (a)", (Object)((UniqueConstraint)tableSchema1.getPrimaryKey().get()).asSummaryString());
        this.tableEnv().executeSql("alter table t2 drop constraint ct1");
        TableSchema tableSchema2 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        org.junit.jupiter.api.Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)tableSchema2.getPrimaryKey().isPresent()));
    }

    @TestTemplate
    public void testCreateTableAndShowCreateTable() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  a bigint not null,\n        |  h string,\n        |  g as 2*(a+1),\n        |  b string not null,\n        |  c bigint metadata virtual,\n        |  e row<name string, age int, flag boolean>,\n        |  f as myfunc(a),\n        |  ts1 timestamp(3),\n        |  ts2 timestamp_ltz(3) metadata from 'timestamp',\n        |  `__source__` varchar(255),\n        |  proc as proctime(),\n        |  watermark for ts1 as cast(timestampadd(hour, 8, ts1) as timestamp(3)),\n        |  constraint test_constraint primary key (a, b) not enforced\n        |) comment 'test show create table statement'\n        |partitioned by (b,h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `a` BIGINT NOT NULL,\n        |  `h` VARCHAR(2147483647),\n        |  `g` AS 2 * (`a` + 1),\n        |  `b` VARCHAR(2147483647) NOT NULL,\n        |  `c` BIGINT METADATA VIRTUAL,\n        |  `e` ROW<`name` VARCHAR(2147483647), `age` INT, `flag` BOOLEAN>,\n        |  `f` AS `default_catalog`.`default_database`.`myfunc`(`a`),\n        |  `ts1` TIMESTAMP(3),\n        |  `ts2` TIMESTAMP(3) WITH LOCAL TIME ZONE METADATA FROM 'timestamp',\n        |  `__source__` VARCHAR(255),\n        |  `proc` AS PROCTIME(),\n        |  WATERMARK FOR `ts1` AS CAST(TIMESTAMPADD(HOUR, 8, `ts1`) AS TIMESTAMP(3)),\n        |  CONSTRAINT `test_constraint` PRIMARY KEY (`a`, `b`) NOT ENFORCED\n        |) COMMENT 'test show create table statement'\n        |PARTITIONED BY (`b`, `h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDDL, (Object)row.getField(0));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`")).withMessageContaining("Could not execute SHOW CREATE TABLE. Table with identifier `default_catalog`.`default_database`.`tmp` does not exist.");
    }

    @TestTemplate
    public void testCreateTableWithCommentAndShowCreateTable() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  pk1 bigint not null comment 'this is column pk1 which part of primary key',\n        |  h string,\n        |  a bigint,\n        |  g as 2*(a+1) comment 'notice: computed column, expression ''2*(`a`+1)''.',\n        |  pk2 string not null comment 'this is column pk2 which part of primary key',\n        |  c bigint metadata virtual comment 'notice: metadata column, named ''c''.',\n        |  e row<name string, age int, flag boolean>,\n        |  f as myfunc(a),\n        |  ts1 timestamp(3) comment 'notice: watermark, named ''ts1''.',\n        |  ts2 timestamp_ltz(3) metadata from 'timestamp' comment 'notice: metadata column, named ''ts2''.',\n        |  `__source__` varchar(255),\n        |  proc as proctime(),\n        |  watermark for ts1 as cast(timestampadd(hour, 8, ts1) as timestamp(3)),\n        |  constraint test_constraint primary key (pk1, pk2) not enforced\n        |) comment 'test show create table statement'\n        |partitioned by (h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `pk1` BIGINT NOT NULL COMMENT 'this is column pk1 which part of primary key',\n        |  `h` VARCHAR(2147483647),\n        |  `a` BIGINT,\n        |  `g` AS 2 * (`a` + 1) COMMENT 'notice: computed column, expression ''2*(`a`+1)''.',\n        |  `pk2` VARCHAR(2147483647) NOT NULL COMMENT 'this is column pk2 which part of primary key',\n        |  `c` BIGINT METADATA VIRTUAL COMMENT 'notice: metadata column, named ''c''.',\n        |  `e` ROW<`name` VARCHAR(2147483647), `age` INT, `flag` BOOLEAN>,\n        |  `f` AS `default_catalog`.`default_database`.`myfunc`(`a`),\n        |  `ts1` TIMESTAMP(3) COMMENT 'notice: watermark, named ''ts1''.',\n        |  `ts2` TIMESTAMP(3) WITH LOCAL TIME ZONE METADATA FROM 'timestamp' COMMENT 'notice: metadata column, named ''ts2''.',\n        |  `__source__` VARCHAR(255),\n        |  `proc` AS PROCTIME(),\n        |  WATERMARK FOR `ts1` AS CAST(TIMESTAMPADD(HOUR, 8, `ts1`) AS TIMESTAMP(3)),\n        |  CONSTRAINT `test_constraint` PRIMARY KEY (`pk1`, `pk2`) NOT ENFORCED\n        |) COMMENT 'test show create table statement'\n        |PARTITIONED BY (`h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDDL, (Object)row.getField(0).toString());
    }

    @TestTemplate
    public void testCreateViewAndShowCreateTable() {
        String createTableDDL = new StringOps(Predef$.MODULE$.augmentString(" |create table `source` (\n        |  `id` bigint not null,\n        | `group` string not null,\n        | `score` double\n        |) with (\n        |  'connector' = 'source-only'\n        |)\n        |")).stripMargin();
        String createViewDDL = new StringOps(Predef$.MODULE$.augmentString(" |create view `tmp` as\n        |select `group`, avg(`score`) as avg_score\n        |from `source`\n        |group by `group`\n        |")).stripMargin();
        this.tableEnv().executeSql(createTableDDL);
        this.tableEnv().executeSql(createViewDDL);
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`")).withMessageContaining("SHOW CREATE TABLE is only supported for tables, but `default_catalog`.`default_database`.`tmp` is a view. Please use SHOW CREATE VIEW instead.");
    }

    @TestTemplate
    public void testAlterViewRename() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   id INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT * FROM T");
        this.tableEnv().executeSql("ALTER VIEW V RENAME TO V2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listViews())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V2"})));
    }

    @TestTemplate
    public void testAlterViewAs() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   a INT,\n                          |   b INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT a FROM T");
        this.tableEnv().executeSql("ALTER VIEW V AS SELECT b FROM T");
        ObjectPath objectPath = new ObjectPath(this.tableEnv().getCurrentDatabase(), "V");
        CatalogView view = (CatalogView)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(objectPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SELECT `b`\nFROM `T`", (Object)view.getOriginalQuery());
    }

    @TestTemplate
    public void testUseCatalogAndShowCurrentCatalog() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("cat1"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("cat2"));
        this.tableEnv().executeSql("use catalog cat1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"cat1", (Object)this.tableEnv().getCurrentCatalog());
        this.tableEnv().executeSql("use catalog cat2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"cat2", (Object)this.tableEnv().getCurrentCatalog());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[cat2]", (Object)((Row)this.tableEnv().executeSql("show current catalog").collect().next()).toString());
    }

    @TestTemplate
    public void testUseDatabaseAndShowCurrentDatabase() {
        GenericInMemoryCatalog catalog = new GenericInMemoryCatalog("cat1");
        this.tableEnv().registerCatalog("cat1", (Catalog)catalog);
        CatalogDatabaseImpl catalogDB1 = new CatalogDatabaseImpl(new HashMap(), "db1");
        CatalogDatabaseImpl catalogDB2 = new CatalogDatabaseImpl(new HashMap(), "db2");
        catalog.createDatabase("db1", (CatalogDatabase)catalogDB1, true);
        catalog.createDatabase("db2", (CatalogDatabase)catalogDB2, true);
        this.tableEnv().executeSql("use cat1.db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db1", (Object)this.tableEnv().getCurrentDatabase());
        String currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[db1]", (Object)currentDatabase);
        this.tableEnv().executeSql("use db2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db2", (Object)this.tableEnv().getCurrentDatabase());
        currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[db2]", (Object)currentDatabase);
    }

    @TestTemplate
    public void testCreateDatabase() {
        Object object;
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 ");
        this.tableEnv().executeSql("create database if not exists db1 ");
        try {
            this.tableEnv().executeSql("create database db1 ");
            object = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("create database cat2.db1 comment 'test_comment' with ('k1' = 'v1', 'k2' = 'v2')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat2").get()).getDatabase("db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_comment", (Object)database.getComment());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "v1");
        expectedProperty.put("k2", "v2");
        org.junit.jupiter.api.Assertions.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @TestTemplate
    public void testDropDatabase() {
        Object object;
        Object object2;
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("drop database db1");
        this.tableEnv().executeSql("drop database if exists db1");
        try {
            this.tableEnv().executeSql("drop database db1");
            object2 = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object2 = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("use db1");
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl2);
        Assertions.assertThatThrownBy(() -> this.tableEnv().executeSql("drop database db1")).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Cannot drop a database which is currently in use.")});
        this.tableEnv().executeSql("use `default`");
        try {
            this.tableEnv().executeSql("drop database db1");
            object = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("drop database db1 cascade");
    }

    @TestTemplate
    public void testAlterDatabase() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 comment 'db1_comment' with ('k1' = 'v1')");
        this.tableEnv().executeSql("alter database db1 set ('k1' = 'a', 'k2' = 'b')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat1").get()).getDatabase("db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db1_comment", (Object)database.getComment());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "a");
        expectedProperty.put("k2", "b");
        org.junit.jupiter.api.Assertions.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @TestTemplate
    public void testLoadFunction() {
        this.tableEnv().registerCatalog("cat2", (Catalog)new TestValuesCatalog("cat2", "default", true));
        this.tableEnv().executeSql("use catalog cat2");
        Random random = new Random();
        String udfClassName = new java.lang.StringBuilder(8).append("LowerUDF").append(random.nextInt(50)).toString();
        String jarPath = UserClassLoaderJarTestUtils.createJarFile((File)TempDirUtils.newFolder((Path)this.tmpDir, (String[])new String[]{String.format("test-jar-%s", UUID.randomUUID())}), (String)"test-classloader-udf.jar", (String)udfClassName, (String)String.format("public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n", udfClassName)).toURI().toString();
        this.tableEnv().executeSql(new java.lang.StringBuilder(43).append("create function lowerUdf as '").append(udfClassName).append("' using jar '").append(jarPath).append("'").toString());
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"BoB"}), (List)Nil$.MODULE$)));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[bob]", (Object)((Row)this.tableEnv().executeSql("select lowerUdf(a) from t1").collect().next()).toString());
    }

    public CatalogTableITCase(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
    }
}

