/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001f\t\u00012)\u0019;bY><G+\u00192mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tqaY1uC2|wM\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\tA\u0001^#omV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u0005\u0019\u0011\r]5\n\u0005\r\u0002#\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0019)\u0003\u0001)A\u0005=\u0005)A/\u00128wA!)q\u0005\u0001C\u0001Q\u0005iA/Z:u\t\u0012c5k\u00195f[\u0006$\u0012!\u000b\t\u0003#)J!a\u000b\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003M5\u0002\"A\f\u001b\u000e\u0003=R!!\t\u0019\u000b\u0005E\u0012\u0014a\u00026va&$XM\u001d\u0006\u0003g1\tQA[;oSRL!!N\u0018\u0003\tQ+7\u000f\u001e")
public class CatalogTableTest {
    private final TableEnvironment tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().build());

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    @Test
    public void testDDLSchema() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t1 (\n        |  f1 INT,\n        |  f2 BIGINT NOT NULL,\n        |  f3 STRING,\n        |  f4 DECIMAL(10, 4),\n        |  f5 TIMESTAMP(2) NOT NULL,\n        |  f6 TIME,\n        |  f7 DATE,\n        |  f8 VARCHAR(10) NOT NULL,\n        |  c AS f3 || f8\n        |) WITH (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin());
        ResolvedSchema actual = this.tEnv().sqlQuery("SELECT * FROM t1").getResolvedSchema();
        ResolvedSchema expected = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f1", (DataType)DataTypes.INT()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"f3", (DataType)DataTypes.STRING()), Column.physical((String)"f4", (DataType)DataTypes.DECIMAL((int)10, (int)4)), Column.physical((String)"f5", (DataType)((DataType)DataTypes.TIMESTAMP((int)2).notNull())), Column.physical((String)"f6", (DataType)DataTypes.TIME()), Column.physical((String)"f7", (DataType)DataTypes.DATE()), Column.physical((String)"f8", (DataType)((DataType)DataTypes.VARCHAR((int)10).notNull())), Column.physical((String)"c", (DataType)DataTypes.STRING())});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

