/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.catalog.CatalogViewITCase$;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001=\u0011\u0011cQ1uC2|wMV5fo&#6)Y:f\u0015\t\u0019A!A\u0004dCR\fGn\\4\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\u0010)\u0006\u0014G.Z%U\u0007\u0006\u001cXMQ1tK\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\bjgN#(/Z1nS:<Wj\u001c3f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001d\u0011un\u001c7fC:DQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDCA\u0011$!\t\u0011\u0003!D\u0001\u0003\u0011\u00159b\u00041\u0001\u0019\u0011\u001d)\u0003A1A\u0005\n\u0019\n\u0001b]3ui&twm]\u000b\u0002OA\u0011\u0001fK\u0007\u0002S)\u0011!FB\u0001\u0004CBL\u0017B\u0001\u0017*\u0005M)eN^5s_:lWM\u001c;TKR$\u0018N\\4t\u0011\u0019q\u0003\u0001)A\u0005O\u0005I1/\u001a;uS:<7\u000f\t\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0003!!\u0018M\u00197f\u000b:4X#\u0001\u001a\u0011\u0005!\u001a\u0014B\u0001\u001b*\u0005A!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG\u000f\u0003\u00047\u0001\u0001\u0006IAM\u0001\ni\u0006\u0014G.Z#om\u0002BQ\u0001\u000f\u0001\u0005\u0002e\naAY3g_J,G#\u0001\u001e\u0011\u0005eY\u0014B\u0001\u001f\u001b\u0005\u0011)f.\u001b;)\u0005]r\u0004CA F\u001b\u0005\u0001%B\u0001\u0016B\u0015\t\u00115)A\u0004kkBLG/\u001a:\u000b\u0005\u0011c\u0011!\u00026v]&$\u0018B\u0001$A\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006\u0011\u0002!\u0019!S\u0001\fe><xJ\u001d3fe&tw-F\u0001K!\rY5K\u0016\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012B\u0001*\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0011=\u0013H-\u001a:j]\u001eT!A\u0015\u000e\u0011\u0005]SV\"\u0001-\u000b\u0005eC\u0011!\u0002;za\u0016\u001c\u0018BA.Y\u0005\r\u0011vn\u001e\u0005\u0006;\u0002!\tAX\u0001\u0006i>\u0014vn\u001e\u000b\u0003-~CQ\u0001\u0019/A\u0002\u0005\fA!\u0019:hgB\u0019\u0011D\u00193\n\u0005\rT\"A\u0003\u001fsKB,\u0017\r^3e}A\u0011\u0011$Z\u0005\u0003Mj\u00111!\u00118z\u0011\u0015A\u0007\u0001\"\u0001:\u0003y!Xm\u001d;De\u0016\fG/\u001a,jK^LeMT8u\u000bbL7\u000f^:Uo&\u001cW\r\u000b\u0002hUB\u0011qh[\u0005\u0003Y\u0002\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016DQA\u001c\u0001\u0005\u0002e\n\u0011\u0006^3ti\u000e\u0013X-\u0019;f-&,woV5uQ>,HOR5fY\u0012d\u0015n\u001d;B]\u0012<\u0016\u000e\u001e5Ti\u0006\u0014\bFA7k\u0011\u0015\t\b\u0001\"\u0001:\u0003]!Xm\u001d;De\u0016\fG/\u001a+f[B|'/\u0019:z-&,w\u000f\u000b\u0002qU\")A\u000f\u0001C\u0001s\u0005qC/Z:u)\u0016l\u0007o\u001c:bef4\u0016.Z<NCN\\\u0007+\u001a:nC:,g\u000e\u001e,jK^<\u0016\u000e\u001e5TC6,g*Y7fQ\t\u0019(\u000eC\u0003x\u0001\u0011%\u00010\u0001\u000bck&dG\rV1cY\u0016$Um]2sSB$xN\u001d\u000b\u0002sB\u0011\u0001F_\u0005\u0003w&\u0012q\u0002V1cY\u0016$Um]2sSB$xN\u001d\u0005\u0006{\u0002!\t!O\u0001(i\u0016\u001cHo\u00155po\u000e\u0013X-\u0019;f#V,'/_(qKJ\fG/[8o\u0007\u0006$\u0018\r\\8h-&,w\u000f\u000b\u0002}U\"1\u0011\u0011\u0001\u0001\u0005\u0002e\n1\u0004^3tiNCwn^\"sK\u0006$X\rV3na>\u0014\u0018M]=WS\u0016<\bFA@k\u0011\u0019\t9\u0001\u0001C\u0001s\u0005IB/Z:u'\"|wo\u0011:fCR,7)\u0019;bY><g+[3xQ\r\t)A\u001b\u0005\u0007\u0003\u001b\u0001A\u0011A\u001d\u0002KQ,7\u000f^*i_^\u001c%/Z1uKZKWm^,ji\"dUM\u001a;K_&twI]8va\nK\bfAA\u0006U\"1\u00111\u0003\u0001\u0005\u0002e\n!\u0005^3tiNCwn^\"sK\u0006$XMV5fo^KG\u000f[+E\r>+H/\u001a:K_&t\u0007fAA\tU\"1\u0011\u0011\u0004\u0001\u0005\u0002e\nq\u0004^3tiNCwn^\"sK\u0006$XMV5fo^KG\u000f[%o]\u0016\u0014(j\\5oQ\r\t9B\u001b\u0015\b\u0001\u0005}\u00111FA\u0017!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u0001\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003S\t\u0019C\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a\f$\u0005\u0005E\u0002\u0003BA\u001a\u0003\u0007j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\u0005m\u0012QH\u0001\u000bKb$XM\\:j_:\u001c(b\u0001#\u0002@)\u0019\u0011\u0011\t\u0005\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002BA#\u0003k\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:<q!!\u0013\u0003\u0011\u0003\tY%A\tDCR\fGn\\4WS\u0016<\u0018\nV\"bg\u0016\u00042AIA'\r\u0019\t!\u0001#\u0001\u0002PM!\u0011QJA)!\rI\u00121K\u0005\u0004\u0003+R\"AB!osJ+g\rC\u0004 \u0003\u001b\"\t!!\u0017\u0015\u0005\u0005-\u0003\u0002CA/\u0003\u001b\"\t!a\u0018\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002bA)\u00111MA715\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003vi&d'BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014Q\r\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0006CA.\u0003g\nI(a\u001f\u0011\t\u0005M\u0012QO\u0005\u0005\u0003o\n)D\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012\u0011QP\u0001\u0004wBj\b")
public class CatalogViewITCase
extends TableITCaseBase {
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogViewITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    @BeforeEach
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Row toRow(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    @TestTemplate
    public void testCreateViewIfNotExistsTwice() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewWith3ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String viewWith2ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e) AS SELECT a, b FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewWith3ColumnDDL);
        this.tableEnv().executeSql(viewWith2ColumnDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testCreateViewWithoutFieldListAndWithStar() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT * FROM T1\n      ")).stripMargin();
        String query = "SELECT * FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testCreateTemporaryView() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testTemporaryViewMaskPermanentViewWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String permanentView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        .colon.colon permanentViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String temporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW IF NOT EXISTS T3 AS SELECT a, b, c+1 FROM T1\n      ")).stripMargin();
        .colon.colon temporaryViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(permanentView);
        this.tableEnv().executeSql(temporaryView);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT * FROM T3";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)temporaryViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY VIEW IF EXISTS T3\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryView);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)permanentViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    /*
     * WARNING - void declaration
     */
    private TableDescriptor buildTableDescriptor() {
        void var1_1;
        TableDescriptor tableDescriptor = TableFactoryHarness.newBuilder().boundedScanSource().schema(Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.STRING()).column("c", (AbstractDataType)DataTypes.INT()).build()).sink().build();
        return var1_1;
    }

    @TestTemplate
    public void testShowCreateQueryOperationCatalogView() {
        Table table = this.tableEnv().from(this.buildTableDescriptor());
        this.tableEnv().createTemporaryView("QueryOperationCatalogView", table);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tableEnv().executeSql("show create view QueryOperationCatalogView")).hasMessageContaining("SHOW CREATE VIEW is not supported for views registered by Table API.") instanceof TableException;
    }

    @TestTemplate
    public void testShowCreateTemporaryView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String tView1DDL = "CREATE TEMPORARY VIEW t_v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView1DDL);
        java.util.List tView1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v1").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)tView1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v1`(`a`, `b`, `c`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
        String tView2DDL = "CREATE TEMPORARY VIEW t_v2(d, e, f) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView2DDL);
        java.util.List tView2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v2").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)tView2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v2`(`d`, `e`, `f`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateCatalogView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String view1DDL = "CREATE VIEW v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view1DDL);
        java.util.List view1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v1").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)view1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v1`(`a`, `b`, `c`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
        String view2DDL = "CREATE VIEW v2(x, y, z) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view2DDL);
        java.util.List view2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v2").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)view2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v2`(`x`, `y`, `z`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithLeftJoinGroupBy() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithLeftJoinGroupByDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewLeftJoinGroupBy as\n         |select max(t1.a) max_value\n         |from t1 left join t2 on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithLeftJoinGroupByDDL);
        java.util.List showCreateLeftJoinGroupByViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewLeftJoinGroupBy").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateLeftJoinGroupByViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewLeftJoinGroupBy`(`max_value`) as\n             |SELECT MAX(`t1`.`a`) AS `max_value`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |LEFT JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithUDFOuterJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        this.tableEnv().createTemporarySystemFunction("udfEqualsOne", (UserDefinedFunction)new ScalarFunction(null){

            public int eval() {
                return 1;
            }
        });
        String viewWithCrossJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewWithCrossJoin as\n         |select udfEqualsOne() a, t1.a a1, t2.b b2 from t1 cross join t2")).stripMargin();
        this.tableEnv().executeSql(viewWithCrossJoinDDL);
        java.util.List showCreateCrossJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewWithCrossJoin").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateCrossJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewWithCrossJoin`(`a`, `a1`, `b2`) as\n             |SELECT `udfEqualsOne`() AS `a`, `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |CROSS JOIN `default_catalog`.`default_database`.`t2`")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithInnerJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithInnerJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view innerJoinView as\n         |select t1.a a1, t2.b b2\n         |from t1 inner join t2\n         |on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithInnerJoinDDL);
        java.util.List showCreateInnerJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view innerJoinView").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateInnerJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`innerJoinView`(`a1`, `b2`) as\n             |SELECT `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |INNER JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`")).stripMargin()})}));
    }

    public CatalogViewITCase(boolean isStreamingMode) {
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
    }
}

